/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.upload;

import com.jfinal.upload.ExceededSizeException;
import com.jfinal.upload.UploadFile;
import com.oreilly.servlet.multipart.DefaultFileRenamePolicy;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultipartRequest
extends HttpServletRequestWrapper {
    private static String baseUploadPath;
    private static long maxPostSize;
    private static String encoding;
    static FileRenamePolicy fileRenamePolicy;
    private List<UploadFile> uploadFiles;
    private com.oreilly.servlet.MultipartRequest multipartRequest;

    static void init(String baseUploadPath, long maxPostSize, String encoding) {
        MultipartRequest.baseUploadPath = baseUploadPath;
        MultipartRequest.maxPostSize = maxPostSize;
        MultipartRequest.encoding = encoding;
    }

    public MultipartRequest(HttpServletRequest request, String uploadPath, long maxPostSize, String encoding) {
        super(request);
        this.wrapMultipartRequest(request, this.getFinalPath(uploadPath), maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request, String uploadPath, long maxPostSize) {
        super(request);
        this.wrapMultipartRequest(request, this.getFinalPath(uploadPath), maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request, String uploadPath) {
        super(request);
        this.wrapMultipartRequest(request, this.getFinalPath(uploadPath), maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request) {
        super(request);
        this.wrapMultipartRequest(request, baseUploadPath, maxPostSize, encoding);
    }

    private String getFinalPath(String uploadPath) {
        if (uploadPath == null) {
            throw new IllegalArgumentException("uploadPath can not be null.");
        }
        if ((uploadPath = uploadPath.trim()).startsWith("/") || uploadPath.startsWith("\\")) {
            if (baseUploadPath.equals("/")) {
                return uploadPath;
            }
            return baseUploadPath + uploadPath;
        }
        return baseUploadPath + File.separator + uploadPath;
    }

    private void wrapMultipartRequest(HttpServletRequest request, String uploadPath, long maxPostSize, String encoding) {
        File dir = new File(uploadPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Directory " + uploadPath + " not exists and can not create directory.");
        }
        this.uploadFiles = new ArrayList<UploadFile>();
        try {
            this.multipartRequest = new com.oreilly.servlet.MultipartRequest(request, uploadPath, maxPostSize, encoding, fileRenamePolicy);
            Enumeration files = this.multipartRequest.getFileNames();
            while (files.hasMoreElements()) {
                String contentType;
                String originalFileName;
                UploadFile uploadFile;
                String name = (String)files.nextElement();
                String filesystemName = this.multipartRequest.getFilesystemName(name);
                if (filesystemName == null || !this.isSafeFile(uploadFile = new UploadFile(name, uploadPath, filesystemName, originalFileName = this.multipartRequest.getOriginalFileName(name), contentType = this.multipartRequest.getContentType(name)))) continue;
                this.uploadFiles.add(uploadFile);
            }
        }
        catch (com.oreilly.servlet.multipart.ExceededSizeException e) {
            throw new ExceededSizeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSafeFile(UploadFile uploadFile) {
        String fileName = uploadFile.getFileName().trim().toLowerCase();
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspx")) {
            uploadFile.getFile().delete();
            return false;
        }
        return true;
    }

    public List<UploadFile> getFiles() {
        return this.uploadFiles;
    }

    public Enumeration getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumm = this.getParameterNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            map.put(name, this.multipartRequest.getParameterValues(name));
        }
        return map;
    }

    static {
        fileRenamePolicy = new DefaultFileRenamePolicy();
    }
}

