/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.proto.tracker.internal;

import com.luhuiguo.fastdfs.domain.GroupState;
import com.luhuiguo.fastdfs.proto.FdfsResponse;
import com.luhuiguo.fastdfs.proto.mapper.FdfsParamMapper;
import com.luhuiguo.fastdfs.proto.mapper.ObjectMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TrackerListGroupsResponse
extends FdfsResponse<List<GroupState>> {
    @Override
    public List<GroupState> decodeContent(InputStream in, Charset charset) throws IOException {
        byte[] bytes = new byte[(int)this.getContentLength()];
        int contentSize = in.read(bytes);
        if ((long)contentSize != this.getContentLength()) {
            try {
                return this.decode(bytes, charset);
            }
            catch (Exception e) {
                throw new IOException("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e0e\u534f\u8bae\u957f\u5ea6\u4e0d\u7b26");
            }
        }
        return this.decode(bytes, charset);
    }

    private List<GroupState> decode(byte[] bs, Charset charset) throws IOException {
        ObjectMetaData objectMetaData = FdfsParamMapper.getObjectMap(GroupState.class);
        int fixFieldsTotalSize = objectMetaData.getFieldsFixTotalSize();
        if (bs.length % fixFieldsTotalSize != 0) {
            throw new IOException("byte array length: " + bs.length + " is invalid!");
        }
        int count = bs.length / fixFieldsTotalSize;
        int offset = 0;
        ArrayList<GroupState> results = new ArrayList<GroupState>(count);
        for (int i = 0; i < count; ++i) {
            byte[] one = new byte[fixFieldsTotalSize];
            System.arraycopy(bs, offset, one, 0, fixFieldsTotalSize);
            results.add(FdfsParamMapper.map(one, GroupState.class, charset));
            offset += fixFieldsTotalSize;
        }
        return results;
    }
}

