/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.service;

import com.luhuiguo.fastdfs.conn.TrackerConnectionManager;
import com.luhuiguo.fastdfs.domain.GroupState;
import com.luhuiguo.fastdfs.domain.StorageNode;
import com.luhuiguo.fastdfs.domain.StorageNodeInfo;
import com.luhuiguo.fastdfs.domain.StorageState;
import com.luhuiguo.fastdfs.proto.tracker.TrackerDeleteStorageCommand;
import com.luhuiguo.fastdfs.proto.tracker.TrackerGetFetchStorageCommand;
import com.luhuiguo.fastdfs.proto.tracker.TrackerGetStoreStorageCommand;
import com.luhuiguo.fastdfs.proto.tracker.TrackerListGroupsCommand;
import com.luhuiguo.fastdfs.proto.tracker.TrackerListStoragesCommand;
import com.luhuiguo.fastdfs.service.TrackerClient;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultTrackerClient
implements TrackerClient {
    private TrackerConnectionManager trackerConnectionManager;

    public DefaultTrackerClient(TrackerConnectionManager trackerConnectionManager) {
        this.trackerConnectionManager = trackerConnectionManager;
    }

    @Override
    public StorageNode getStoreStorage() {
        TrackerGetStoreStorageCommand command = new TrackerGetStoreStorageCommand();
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNode getStoreStorage(String groupName) {
        TrackerGetStoreStorageCommand command = StringUtils.isBlank((CharSequence)groupName) ? new TrackerGetStoreStorageCommand() : new TrackerGetStoreStorageCommand(groupName);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNodeInfo getFetchStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, false);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNodeInfo getUpdateStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, true);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<GroupState> listGroups() {
        TrackerListGroupsCommand command = new TrackerListGroupsCommand();
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<StorageState> listStorages(String groupName) {
        TrackerListStoragesCommand command = new TrackerListStoragesCommand(groupName);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<StorageState> listStorages(String groupName, String storageIpAddr) {
        TrackerListStoragesCommand command = new TrackerListStoragesCommand(groupName, storageIpAddr);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public void deleteStorage(String groupName, String storageIpAddr) {
        TrackerDeleteStorageCommand command = new TrackerDeleteStorageCommand(groupName, storageIpAddr);
        this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }
}

