/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit;

import com.ecwid.consul.v1.ConsulClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.hazelcast.core.IMap;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.ConsulRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.DefaultRateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.InMemoryRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RedisRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jHazelcastRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jIgniteRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jInfinispanRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jJCacheRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.JpaRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.RateLimiterRepository;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPostFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPreFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.DefaultRateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.DefaultRateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.StringToMatchTypeConverter;
import com.netflix.zuul.ZuulFilter;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.hazelcast.Hazelcast;
import io.github.bucket4j.grid.ignite.Ignite;
import io.github.bucket4j.grid.infinispan.Infinispan;
import io.github.bucket4j.grid.jcache.JCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.infinispan.functional.FunctionalMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@EnableConfigurationProperties(value={RateLimitProperties.class})
@ConditionalOnProperty(prefix="zuul.ratelimit", name={"enabled"}, havingValue="true")
public class RateLimitAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringToMatchTypeConverter stringToMatchTypeConverter() {
        return new StringToMatchTypeConverter();
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimiterErrorHandler.class})
    public RateLimiterErrorHandler rateLimiterErrorHandler() {
        return new DefaultRateLimiterErrorHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimitUtils.class})
    public RateLimitUtils rateLimitUtils(RateLimitProperties rateLimitProperties) {
        return new DefaultRateLimitUtils(rateLimitProperties);
    }

    @Bean
    public ZuulFilter rateLimiterPreFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator, RateLimitUtils rateLimitUtils) {
        return new RateLimitPreFilter(rateLimitProperties, routeLocator, new UrlPathHelper(), rateLimiter, rateLimitKeyGenerator, rateLimitUtils);
    }

    @Bean
    public ZuulFilter rateLimiterPostFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator, RateLimitUtils rateLimitUtils) {
        return new RateLimitPostFilter(rateLimitProperties, routeLocator, new UrlPathHelper(), rateLimiter, rateLimitKeyGenerator, rateLimitUtils);
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimitKeyGenerator.class})
    public RateLimitKeyGenerator ratelimitKeyGenerator(RateLimitProperties properties, RateLimitUtils rateLimitUtils) {
        return new DefaultRateLimitKeyGenerator(properties, rateLimitUtils);
    }

    @Configuration
    protected static class RateLimitPropertiesAdjuster {
        private final RateLimitProperties rateLimitProperties;

        @PostConstruct
        public void init() {
            RateLimitProperties.Policy defaultPolicy = this.rateLimitProperties.getDefaultPolicy();
            if (defaultPolicy != null) {
                ArrayList defaultPolicies = Lists.newArrayList((Object[])new RateLimitProperties.Policy[]{defaultPolicy});
                defaultPolicies.addAll(this.rateLimitProperties.getDefaultPolicyList());
                this.rateLimitProperties.setDefaultPolicyList(defaultPolicies);
            }
            this.rateLimitProperties.getPolicies().forEach((route, policy) -> this.rateLimitProperties.getPolicyList().compute((String)route, (key, policies) -> this.getPolicies((RateLimitProperties.Policy)policy, (List<RateLimitProperties.Policy>)policies)));
        }

        private List<RateLimitProperties.Policy> getPolicies(RateLimitProperties.Policy policy, List<RateLimitProperties.Policy> policies) {
            ArrayList combinedPolicies = Lists.newArrayList((Object[])new RateLimitProperties.Policy[]{policy});
            if (policies != null) {
                combinedPolicies.addAll(policies);
            }
            return combinedPolicies;
        }

        public RateLimitPropertiesAdjuster(RateLimitProperties rateLimitProperties) {
            this.rateLimitProperties = rateLimitProperties;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="IN_MEMORY", matchIfMissing=true)
    public static class InMemoryConfiguration {
        @Bean
        public RateLimiter inMemoryRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler) {
            return new InMemoryRateLimiter(rateLimiterErrorHandler);
        }
    }

    @EntityScan
    @Configuration
    @EnableJpaRepositories
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="JPA")
    public static class SpringDataConfiguration {
        @Bean
        public RateLimiter springDataRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, RateLimiterRepository rateLimiterRepository) {
            return new JpaRateLimiter(rateLimiterErrorHandler, rateLimiterRepository);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Infinispan.class, FunctionalMap.ReadWriteMap.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_INFINISPAN")
    public static class Bucket4jInfinispanConfiguration {
        @Bean
        public RateLimiter bucket4jInfinispanRateLimiter(@Qualifier(value="RateLimit") FunctionalMap.ReadWriteMap<String, GridBucketState> readWriteMap) {
            return new Bucket4jInfinispanRateLimiter(readWriteMap);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Ignite.class, IgniteCache.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_IGNITE")
    public static class Bucket4jIgniteConfiguration {
        @Bean
        public RateLimiter bucket4jIgniteRateLimiter(@Qualifier(value="RateLimit") IgniteCache<String, GridBucketState> cache) {
            return new Bucket4jIgniteRateLimiter(cache);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Hazelcast.class, IMap.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_HAZELCAST")
    public static class Bucket4jHazelcastConfiguration {
        @Bean
        public RateLimiter bucket4jHazelcastRateLimiter(@Qualifier(value="RateLimit") IMap<String, GridBucketState> rateLimit) {
            return new Bucket4jHazelcastRateLimiter(rateLimit);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={JCache.class, Cache.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_JCACHE")
    public static class Bucket4jJCacheConfiguration {
        @Bean
        public RateLimiter jCache4jHazelcastRateLimiter(@Qualifier(value="RateLimit") Cache<String, GridBucketState> cache) {
            return new Bucket4jJCacheRateLimiter(cache);
        }
    }

    @Configuration
    @ConditionalOnConsulEnabled
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="CONSUL")
    public static class ConsulConfiguration {
        @Bean
        public RateLimiter consultRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, ConsulClient consulClient, ObjectMapper objectMapper) {
            return new ConsulRateLimiter(rateLimiterErrorHandler, consulClient, objectMapper);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="REDIS")
    public static class RedisConfiguration {
        @Bean(value={"rateLimiterRedisTemplate"})
        public StringRedisTemplate redisTemplate(RedisConnectionFactory connectionFactory) {
            return new StringRedisTemplate(connectionFactory);
        }

        @Bean
        public RateLimiter redisRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, @Qualifier(value="rateLimiterRedisTemplate") RedisTemplate redisTemplate) {
            return new RedisRateLimiter(rateLimiterErrorHandler, redisTemplate);
        }
    }
}

