/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;

public enum RateLimitType {
    ORIGIN{

        @Override
        public boolean apply(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils, String matcher) {
            return matcher.equals(rateLimitUtils.getRemoteAddress(request));
        }

        @Override
        public String key(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
            return rateLimitUtils.getRemoteAddress(request);
        }
    }
    ,
    USER{

        @Override
        public boolean apply(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils, String matcher) {
            return matcher.equals(rateLimitUtils.getUser(request));
        }

        @Override
        public String key(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
            return rateLimitUtils.getUser(request);
        }
    }
    ,
    URL{

        @Override
        public boolean apply(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils, String matcher) {
            return route == null || route.getPath().startsWith(matcher);
        }

        @Override
        public String key(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
            return Optional.ofNullable(route).map(Route::getPath).orElse("");
        }
    };


    public abstract boolean apply(HttpServletRequest var1, Route var2, RateLimitUtils var3, String var4);

    public abstract String key(HttpServletRequest var1, Route var2, RateLimitUtils var3);
}

