/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractCacheRateLimiter;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.Extension;
import io.github.bucket4j.grid.ProxyManager;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractBucket4jRateLimiter<T extends ConfigurationBuilder<T>, E extends Extension<T>>
extends AbstractCacheRateLimiter {
    private final Class<E> extension;
    private ProxyManager<String> buckets;

    public AbstractBucket4jRateLimiter(Class<E> extension) {
        this.extension = extension;
    }

    public void init() {
        this.buckets = this.getProxyManager(this.getExtension());
    }

    private E getExtension() {
        return (E)Bucket4j.extension(this.extension);
    }

    protected abstract ProxyManager<String> getProxyManager(E var1);

    private Bucket getQuotaBucket(String key, Long quota, Long refreshInterval) {
        return this.buckets.getProxy((Serializable)((Object)(key + "-quota")), this.getBucketConfiguration(quota, refreshInterval));
    }

    private Bucket getLimitBucket(String key, Long limit, Long refreshInterval) {
        return this.buckets.getProxy((Serializable)((Object)key), this.getBucketConfiguration(limit, refreshInterval));
    }

    private Supplier<BucketConfiguration> getBucketConfiguration(Long capacity, Long period) {
        return () -> this.getExtension().builder().addLimit(Bandwidth.simple((long)capacity, (Duration)Duration.ofSeconds(period))).buildConfiguration();
    }

    @Override
    protected void calcRemainingLimit(Long limit, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (limit != null) {
            Bucket limitBucket = this.getLimitBucket(key, limit, refreshInterval);
            if (requestTime == null) {
                ConsumptionProbe limitConsumptionProbe = limitBucket.tryConsumeAndReturnRemaining(1L);
                long nanosToWaitForRefill = limitConsumptionProbe.getNanosToWaitForRefill();
                rate.setReset(TimeUnit.NANOSECONDS.toMillis(nanosToWaitForRefill));
                if (limitConsumptionProbe.isConsumed()) {
                    rate.setRemaining(limitConsumptionProbe.getRemainingTokens());
                } else {
                    rate.setRemaining(-1L);
                    limitBucket.tryConsumeAsMuchAsPossible(1L);
                }
            } else {
                long availableTokens = limitBucket.getAvailableTokens();
                rate.setRemaining(availableTokens > 0L ? availableTokens : -1L);
            }
        }
    }

    @Override
    protected void calcRemainingQuota(Long quota, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (quota != null) {
            Bucket quotaBucket = this.getQuotaBucket(key, quota, refreshInterval);
            if (requestTime != null) {
                ConsumptionProbe quotaConsumptionProbe = quotaBucket.tryConsumeAndReturnRemaining(requestTime.longValue());
                long nanosToWaitForRefill = quotaConsumptionProbe.getNanosToWaitForRefill();
                rate.setReset(TimeUnit.NANOSECONDS.toMillis(nanosToWaitForRefill));
                if (quotaConsumptionProbe.isConsumed()) {
                    rate.setRemainingQuota(quotaConsumptionProbe.getRemainingTokens());
                } else {
                    rate.setRemainingQuota(-1L);
                    quotaBucket.tryConsumeAsMuchAsPossible(requestTime.longValue());
                }
            } else {
                long availableTokens = quotaBucket.getAvailableTokens();
                rate.setRemainingQuota(availableTokens > 0L ? availableTokens : -1L);
            }
        }
    }
}

