/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PublishingProfileFormat.
 */
public final class PublishingProfileFormat {
    /** Static value FileZilla3 for PublishingProfileFormat. */
    public static final PublishingProfileFormat FILE_ZILLA3 = new PublishingProfileFormat("FileZilla3");

    /** Static value WebDeploy for PublishingProfileFormat. */
    public static final PublishingProfileFormat WEB_DEPLOY = new PublishingProfileFormat("WebDeploy");

    /** Static value Ftp for PublishingProfileFormat. */
    public static final PublishingProfileFormat FTP = new PublishingProfileFormat("Ftp");

    private String value;

    /**
     * Creates a custom value for PublishingProfileFormat.
     * @param value the custom value
     */
    public PublishingProfileFormat(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PublishingProfileFormat)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PublishingProfileFormat rhs = (PublishingProfileFormat) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
