/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.AppServicePlanRestrictions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Premier add-on offer.
 */
@JsonFlatten
public class PremierAddOnOfferInner extends Resource {
    /**
     * SKU.
     */
    @JsonProperty(value = "properties.sku")
    private String sku;

    /**
     * Product.
     */
    @JsonProperty(value = "properties.product")
    private String product;

    /**
     * Vendor.
     */
    @JsonProperty(value = "properties.vendor")
    private String vendor;

    /**
     * Name.
     */
    @JsonProperty(value = "properties.name")
    private String premierAddOnOfferName;

    /**
     * &lt;code&gt;true&lt;/code&gt; if promotion code is required; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "properties.promoCodeRequired")
    private Boolean promoCodeRequired;

    /**
     * Quota.
     */
    @JsonProperty(value = "properties.quota")
    private Integer quota;

    /**
     * App Service plans this offer is restricted to. Possible values include:
     * 'None', 'Free', 'Shared', 'Basic', 'Standard', 'Premium'.
     */
    @JsonProperty(value = "properties.webHostingPlanRestrictions")
    private AppServicePlanRestrictions webHostingPlanRestrictions;

    /**
     * Privacy policy URL.
     */
    @JsonProperty(value = "properties.privacyPolicyUrl")
    private String privacyPolicyUrl;

    /**
     * Legal terms URL.
     */
    @JsonProperty(value = "properties.legalTermsUrl")
    private String legalTermsUrl;

    /**
     * Marketplace publisher.
     */
    @JsonProperty(value = "properties.marketplacePublisher")
    private String marketplacePublisher;

    /**
     * Marketplace offer.
     */
    @JsonProperty(value = "properties.marketplaceOffer")
    private String marketplaceOffer;

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the product value.
     *
     * @return the product value
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product value.
     *
     * @param product the product value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get the vendor value.
     *
     * @return the vendor value
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set the vendor value.
     *
     * @param vendor the vendor value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get the premierAddOnOfferName value.
     *
     * @return the premierAddOnOfferName value
     */
    public String premierAddOnOfferName() {
        return this.premierAddOnOfferName;
    }

    /**
     * Set the premierAddOnOfferName value.
     *
     * @param premierAddOnOfferName the premierAddOnOfferName value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withPremierAddOnOfferName(String premierAddOnOfferName) {
        this.premierAddOnOfferName = premierAddOnOfferName;
        return this;
    }

    /**
     * Get the promoCodeRequired value.
     *
     * @return the promoCodeRequired value
     */
    public Boolean promoCodeRequired() {
        return this.promoCodeRequired;
    }

    /**
     * Set the promoCodeRequired value.
     *
     * @param promoCodeRequired the promoCodeRequired value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withPromoCodeRequired(Boolean promoCodeRequired) {
        this.promoCodeRequired = promoCodeRequired;
        return this;
    }

    /**
     * Get the quota value.
     *
     * @return the quota value
     */
    public Integer quota() {
        return this.quota;
    }

    /**
     * Set the quota value.
     *
     * @param quota the quota value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withQuota(Integer quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Get the webHostingPlanRestrictions value.
     *
     * @return the webHostingPlanRestrictions value
     */
    public AppServicePlanRestrictions webHostingPlanRestrictions() {
        return this.webHostingPlanRestrictions;
    }

    /**
     * Set the webHostingPlanRestrictions value.
     *
     * @param webHostingPlanRestrictions the webHostingPlanRestrictions value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withWebHostingPlanRestrictions(AppServicePlanRestrictions webHostingPlanRestrictions) {
        this.webHostingPlanRestrictions = webHostingPlanRestrictions;
        return this;
    }

    /**
     * Get the privacyPolicyUrl value.
     *
     * @return the privacyPolicyUrl value
     */
    public String privacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    /**
     * Set the privacyPolicyUrl value.
     *
     * @param privacyPolicyUrl the privacyPolicyUrl value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withPrivacyPolicyUrl(String privacyPolicyUrl) {
        this.privacyPolicyUrl = privacyPolicyUrl;
        return this;
    }

    /**
     * Get the legalTermsUrl value.
     *
     * @return the legalTermsUrl value
     */
    public String legalTermsUrl() {
        return this.legalTermsUrl;
    }

    /**
     * Set the legalTermsUrl value.
     *
     * @param legalTermsUrl the legalTermsUrl value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withLegalTermsUrl(String legalTermsUrl) {
        this.legalTermsUrl = legalTermsUrl;
        return this;
    }

    /**
     * Get the marketplacePublisher value.
     *
     * @return the marketplacePublisher value
     */
    public String marketplacePublisher() {
        return this.marketplacePublisher;
    }

    /**
     * Set the marketplacePublisher value.
     *
     * @param marketplacePublisher the marketplacePublisher value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withMarketplacePublisher(String marketplacePublisher) {
        this.marketplacePublisher = marketplacePublisher;
        return this;
    }

    /**
     * Get the marketplaceOffer value.
     *
     * @return the marketplaceOffer value
     */
    public String marketplaceOffer() {
        return this.marketplaceOffer;
    }

    /**
     * Set the marketplaceOffer value.
     *
     * @param marketplaceOffer the marketplaceOffer value to set
     * @return the PremierAddOnOfferInner object itself.
     */
    public PremierAddOnOfferInner withMarketplaceOffer(String marketplaceOffer) {
        this.marketplaceOffer = marketplaceOffer;
        return this;
    }

}
