/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Options for app content migration.
 */
@JsonFlatten
public class StorageMigrationOptionsInner extends Resource {
    /**
     * AzureFiles connection string.
     */
    @JsonProperty(value = "properties.azurefilesConnectionString")
    private String azurefilesConnectionString;

    /**
     * AzureFiles share.
     */
    @JsonProperty(value = "properties.azurefilesShare")
    private String azurefilesShare;

    /**
     * &lt;code&gt;true&lt;/code&gt;if the app should be switched over;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "properties.switchSiteAfterMigration")
    private Boolean switchSiteAfterMigration;

    /**
     * &lt;code&gt;true&lt;/code&gt; if the app should be read only during copy
     * operation; otherwise, &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "properties.blockWriteAccessToSite")
    private Boolean blockWriteAccessToSite;

    /**
     * Get the azurefilesConnectionString value.
     *
     * @return the azurefilesConnectionString value
     */
    public String azurefilesConnectionString() {
        return this.azurefilesConnectionString;
    }

    /**
     * Set the azurefilesConnectionString value.
     *
     * @param azurefilesConnectionString the azurefilesConnectionString value to set
     * @return the StorageMigrationOptionsInner object itself.
     */
    public StorageMigrationOptionsInner withAzurefilesConnectionString(String azurefilesConnectionString) {
        this.azurefilesConnectionString = azurefilesConnectionString;
        return this;
    }

    /**
     * Get the azurefilesShare value.
     *
     * @return the azurefilesShare value
     */
    public String azurefilesShare() {
        return this.azurefilesShare;
    }

    /**
     * Set the azurefilesShare value.
     *
     * @param azurefilesShare the azurefilesShare value to set
     * @return the StorageMigrationOptionsInner object itself.
     */
    public StorageMigrationOptionsInner withAzurefilesShare(String azurefilesShare) {
        this.azurefilesShare = azurefilesShare;
        return this;
    }

    /**
     * Get the switchSiteAfterMigration value.
     *
     * @return the switchSiteAfterMigration value
     */
    public Boolean switchSiteAfterMigration() {
        return this.switchSiteAfterMigration;
    }

    /**
     * Set the switchSiteAfterMigration value.
     *
     * @param switchSiteAfterMigration the switchSiteAfterMigration value to set
     * @return the StorageMigrationOptionsInner object itself.
     */
    public StorageMigrationOptionsInner withSwitchSiteAfterMigration(Boolean switchSiteAfterMigration) {
        this.switchSiteAfterMigration = switchSiteAfterMigration;
        return this;
    }

    /**
     * Get the blockWriteAccessToSite value.
     *
     * @return the blockWriteAccessToSite value
     */
    public Boolean blockWriteAccessToSite() {
        return this.blockWriteAccessToSite;
    }

    /**
     * Set the blockWriteAccessToSite value.
     *
     * @param blockWriteAccessToSite the blockWriteAccessToSite value to set
     * @return the StorageMigrationOptionsInner object itself.
     */
    public StorageMigrationOptionsInner withBlockWriteAccessToSite(Boolean blockWriteAccessToSite) {
        this.blockWriteAccessToSite = blockWriteAccessToSite;
        return this;
    }

}
