/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ProfileResourceState.
 */
public final class ProfileResourceState {
    /** Static value Creating for ProfileResourceState. */
    public static final ProfileResourceState CREATING = new ProfileResourceState("Creating");

    /** Static value Active for ProfileResourceState. */
    public static final ProfileResourceState ACTIVE = new ProfileResourceState("Active");

    /** Static value Deleting for ProfileResourceState. */
    public static final ProfileResourceState DELETING = new ProfileResourceState("Deleting");

    /** Static value Disabled for ProfileResourceState. */
    public static final ProfileResourceState DISABLED = new ProfileResourceState("Disabled");

    private String value;

    /**
     * Creates a custom value for ProfileResourceState.
     * @param value the custom value
     */
    public ProfileResourceState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProfileResourceState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ProfileResourceState rhs = (ProfileResourceState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
