/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Output of check resource usage API.
 */
public class ResourceUsageInner {
    /**
     * Resource type of the usages.
     */
    @JsonProperty(value = "resourceType")
    private String resourceType;

    /**
     * Unit of the usage. e.g. Count.
     */
    @JsonProperty(value = "unit")
    private String unit;

    /**
     * Actual value of the resource type.
     */
    @JsonProperty(value = "currentValue")
    private Integer currentValue;

    /**
     * Quota of the resource type.
     */
    @JsonProperty(value = "limit")
    private Integer limit;

    /**
     * Get the resourceType value.
     *
     * @return the resourceType value
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Set the resourceType value.
     *
     * @param resourceType the resourceType value to set
     * @return the ResourceUsageInner object itself.
     */
    public ResourceUsageInner withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get the unit value.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit value.
     *
     * @param unit the unit value to set
     * @return the ResourceUsageInner object itself.
     */
    public ResourceUsageInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the currentValue value.
     *
     * @return the currentValue value
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Set the currentValue value.
     *
     * @param currentValue the currentValue value to set
     * @return the ResourceUsageInner object itself.
     */
    public ResourceUsageInner withCurrentValue(Integer currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    /**
     * Get the limit value.
     *
     * @return the limit value
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Set the limit value.
     *
     * @param limit the limit value to set
     * @return the ResourceUsageInner object itself.
     */
    public ResourceUsageInner withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

}
