/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.eventhub.Sku;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Single Namespace item in List or Get Operation.
 */
@JsonFlatten
public class EHNamespaceInner extends Resource {
    /**
     * Properties of sku resource.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /**
     * Provisioning state of the Namespace.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * The time the Namespace was created.
     */
    @JsonProperty(value = "properties.createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime createdAt;

    /**
     * The time the Namespace was updated.
     */
    @JsonProperty(value = "properties.updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime updatedAt;

    /**
     * Endpoint you can use to perform Service Bus operations.
     */
    @JsonProperty(value = "properties.serviceBusEndpoint", access = JsonProperty.Access.WRITE_ONLY)
    private String serviceBusEndpoint;

    /**
     * Identifier for Azure Insights metrics.
     */
    @JsonProperty(value = "properties.metricId", access = JsonProperty.Access.WRITE_ONLY)
    private String metricId;

    /**
     * Value that indicates whether AutoInflate is enabled for eventhub
     * namespace.
     */
    @JsonProperty(value = "properties.isAutoInflateEnabled")
    private Boolean isAutoInflateEnabled;

    /**
     * Upper limit of throughput units when AutoInflate is enabled, vaule
     * should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled =
     * true).
     */
    @JsonProperty(value = "properties.maximumThroughputUnits")
    private Integer maximumThroughputUnits;

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the EHNamespaceInner object itself.
     */
    public EHNamespaceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the createdAt value.
     *
     * @return the createdAt value
     */
    public DateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the updatedAt value.
     *
     * @return the updatedAt value
     */
    public DateTime updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the serviceBusEndpoint value.
     *
     * @return the serviceBusEndpoint value
     */
    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    /**
     * Get the metricId value.
     *
     * @return the metricId value
     */
    public String metricId() {
        return this.metricId;
    }

    /**
     * Get the isAutoInflateEnabled value.
     *
     * @return the isAutoInflateEnabled value
     */
    public Boolean isAutoInflateEnabled() {
        return this.isAutoInflateEnabled;
    }

    /**
     * Set the isAutoInflateEnabled value.
     *
     * @param isAutoInflateEnabled the isAutoInflateEnabled value to set
     * @return the EHNamespaceInner object itself.
     */
    public EHNamespaceInner withIsAutoInflateEnabled(Boolean isAutoInflateEnabled) {
        this.isAutoInflateEnabled = isAutoInflateEnabled;
        return this;
    }

    /**
     * Get the maximumThroughputUnits value.
     *
     * @return the maximumThroughputUnits value
     */
    public Integer maximumThroughputUnits() {
        return this.maximumThroughputUnits;
    }

    /**
     * Set the maximumThroughputUnits value.
     *
     * @param maximumThroughputUnits the maximumThroughputUnits value to set
     * @return the EHNamespaceInner object itself.
     */
    public EHNamespaceInner withMaximumThroughputUnits(Integer maximumThroughputUnits) {
        this.maximumThroughputUnits = maximumThroughputUnits;
        return this;
    }

}
