/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The MetricDimension model.
 */
public class MetricDimension {
    /**
     * Name of the dimension.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * the dimension operator.
     */
    @JsonProperty(value = "operator", required = true)
    private String operator;

    /**
     * list of dimension values.
     */
    @JsonProperty(value = "values", required = true)
    private List<String> values;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the MetricDimension object itself.
     */
    public MetricDimension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the operator value.
     *
     * @return the operator value
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator value.
     *
     * @param operator the operator value to set
     * @return the MetricDimension object itself.
     */
    public MetricDimension withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the values value.
     *
     * @return the values value
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values value.
     *
     * @param values the values value to set
     * @return the MetricDimension object itself.
     */
    public MetricDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

}
