/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A time series result type. The discriminator value is always TimeSeries in
 * this case.
 */
public class TimeSeriesElement {
    /**
     * the metadata values returned if $filter was specified in the call.
     */
    @JsonProperty(value = "metadatavalues")
    private List<MetadataValue> metadatavalues;

    /**
     * An array of data points representing the metric values.  This is only
     * returned if a result type of data is specified.
     */
    @JsonProperty(value = "data")
    private List<MetricValue> data;

    /**
     * Get the metadatavalues value.
     *
     * @return the metadatavalues value
     */
    public List<MetadataValue> metadatavalues() {
        return this.metadatavalues;
    }

    /**
     * Set the metadatavalues value.
     *
     * @param metadatavalues the metadatavalues value to set
     * @return the TimeSeriesElement object itself.
     */
    public TimeSeriesElement withMetadatavalues(List<MetadataValue> metadatavalues) {
        this.metadatavalues = metadatavalues;
        return this;
    }

    /**
     * Get the data value.
     *
     * @return the data value
     */
    public List<MetricValue> data() {
        return this.data;
    }

    /**
     * Set the data value.
     *
     * @param data the data value to set
     * @return the TimeSeriesElement object itself.
     */
    public TimeSeriesElement withData(List<MetricValue> data) {
        this.data = data;
        return this;
    }

}
