/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for Unit.
 */
public enum Unit {
    /** Enum value Count. */
    COUNT("Count"),

    /** Enum value Bytes. */
    BYTES("Bytes"),

    /** Enum value Seconds. */
    SECONDS("Seconds"),

    /** Enum value CountPerSecond. */
    COUNT_PER_SECOND("CountPerSecond"),

    /** Enum value BytesPerSecond. */
    BYTES_PER_SECOND("BytesPerSecond"),

    /** Enum value Percent. */
    PERCENT("Percent"),

    /** Enum value MilliSeconds. */
    MILLI_SECONDS("MilliSeconds"),

    /** Enum value ByteSeconds. */
    BYTE_SECONDS("ByteSeconds"),

    /** Enum value Unspecified. */
    UNSPECIFIED("Unspecified");

    /** The actual serialized value for a Unit instance. */
    private String value;

    Unit(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Unit instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed Unit object, or null if unable to parse.
     */
    @JsonCreator
    public static Unit fromString(String value) {
        Unit[] items = Unit.values();
        for (Unit item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
