/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import java.util.Map;
import java.util.List;
import org.joda.time.Period;
import com.microsoft.azure.management.monitor.MetricAlertCriteria;
import com.microsoft.azure.management.monitor.Action;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The metric alert resource for patch operations.
 */
@JsonFlatten
public class MetricAlertResourcePatchInner {
    /**
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * the description of the metric alert that will be included in the alert
     * email.
     */
    @JsonProperty(value = "properties.description", required = true)
    private String description;

    /**
     * Alert severity {0, 1, 2, 3, 4}.
     */
    @JsonProperty(value = "properties.severity", required = true)
    private int severity;

    /**
     * the flag that indicates whether the metric alert is enabled.
     */
    @JsonProperty(value = "properties.enabled", required = true)
    private boolean enabled;

    /**
     * the list of resource id's that this metric alert is scoped to.
     */
    @JsonProperty(value = "properties.scopes")
    private List<String> scopes;

    /**
     * how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     */
    @JsonProperty(value = "properties.evaluationFrequency", required = true)
    private Period evaluationFrequency;

    /**
     * the period of time (in ISO 8601 duration format) that is used to monitor
     * alert activity based on the threshold.
     */
    @JsonProperty(value = "properties.windowSize", required = true)
    private Period windowSize;

    /**
     * defines the specific alert criteria information.
     */
    @JsonProperty(value = "properties.criteria", required = true)
    private MetricAlertCriteria criteria;

    /**
     * the array of actions that are performed when the alert rule becomes
     * active, and when an alert condition is resolved.
     */
    @JsonProperty(value = "properties.actions")
    private List<Action> actions;

    /**
     * Last time the rule was updated in ISO8601 format.
     */
    @JsonProperty(value = "properties.lastUpdatedTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastUpdatedTime;

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the severity value.
     *
     * @return the severity value
     */
    public int severity() {
        return this.severity;
    }

    /**
     * Set the severity value.
     *
     * @param severity the severity value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the enabled value.
     *
     * @return the enabled value
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled value.
     *
     * @param enabled the enabled value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the scopes value.
     *
     * @return the scopes value
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes value.
     *
     * @param scopes the scopes value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the evaluationFrequency value.
     *
     * @return the evaluationFrequency value
     */
    public Period evaluationFrequency() {
        return this.evaluationFrequency;
    }

    /**
     * Set the evaluationFrequency value.
     *
     * @param evaluationFrequency the evaluationFrequency value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withEvaluationFrequency(Period evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    /**
     * Get the windowSize value.
     *
     * @return the windowSize value
     */
    public Period windowSize() {
        return this.windowSize;
    }

    /**
     * Set the windowSize value.
     *
     * @param windowSize the windowSize value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withWindowSize(Period windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Get the criteria value.
     *
     * @return the criteria value
     */
    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria value.
     *
     * @param criteria the criteria value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Get the actions value.
     *
     * @return the actions value
     */
    public List<Action> actions() {
        return this.actions;
    }

    /**
     * Set the actions value.
     *
     * @param actions the actions value to set
     * @return the MetricAlertResourcePatchInner object itself.
     */
    public MetricAlertResourcePatchInner withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the lastUpdatedTime value.
     *
     * @return the lastUpdatedTime value
     */
    public DateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

}
