/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.PublicIPSkuType;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Set;

@Fluent
public interface PublicIPAddress
extends GroupableResource<NetworkManager, PublicIPAddressInner>,
Refreshable<PublicIPAddress>,
Updatable<Update> {
    public IPVersion version();

    public String ipAddress();

    public String leafDomainLabel();

    public String fqdn();

    public String reverseFqdn();

    public IPAllocationMethod ipAllocationMethod();

    public int idleTimeoutInMinutes();

    public LoadBalancerPublicFrontend getAssignedLoadBalancerFrontend();

    public boolean hasAssignedLoadBalancer();

    public NicIPConfiguration getAssignedNetworkInterfaceIPConfiguration();

    public boolean hasAssignedNetworkInterface();

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public Set<AvailabilityZoneId> availabilityZones();

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public PublicIPSkuType sku();

    public static interface UpdateStages {

        public static interface WithIdleTimout {
            public Update withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithReverseFQDN {
            public Update withReverseFqdn(String var1);

            public Update withoutReverseFqdn();
        }

        public static interface WithLeafDomainLabel {
            public Update withLeafDomainLabel(String var1);

            public Update withoutLeafDomainLabel();
        }

        public static interface WithIPAddress {
            public Update withStaticIP();

            public Update withDynamicIP();
        }
    }

    public static interface Update
    extends Appliable<PublicIPAddress>,
    UpdateStages.WithIPAddress,
    UpdateStages.WithLeafDomainLabel,
    UpdateStages.WithReverseFQDN,
    UpdateStages.WithIdleTimout,
    Resource.UpdateWithTags<Update> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<PublicIPAddress>,
        WithLeafDomainLabel,
        WithIPAddress,
        WithReverseFQDN,
        WithIdleTimeout,
        WithAvailabilityZone,
        WithSku,
        Resource.DefinitionWithTags<WithCreate> {
        }

        @Beta(value=Beta.SinceVersion.V1_3_0)
        public static interface WithSku {
            public WithCreate withSku(PublicIPSkuType var1);
        }

        @Beta(value=Beta.SinceVersion.V1_3_0)
        public static interface WithAvailabilityZone {
            @Beta(value=Beta.SinceVersion.V1_3_0)
            public WithCreate withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithIdleTimeout {
            public WithCreate withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithReverseFQDN {
            public WithCreate withReverseFqdn(String var1);

            public WithCreate withoutReverseFqdn();
        }

        public static interface WithLeafDomainLabel {
            public WithCreate withLeafDomainLabel(String var1);

            public WithCreate withoutLeafDomainLabel();
        }

        public static interface WithIPAddress {
            public WithCreate withStaticIP();

            public WithCreate withDynamicIP();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

