/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerHttpProbe;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.LoadBalancerProbe;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.LoadBalancerSkuType;
import com.microsoft.azure.management.network.LoadBalancerTcpProbe;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.ProbeProtocol;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.InboundNatPoolInner;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerBackendImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancerFrontendImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancerInboundNatPoolImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancerInboundNatRuleImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerProbeImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.ProbeInner;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Func1;

@LangDefinition
class LoadBalancerImpl
extends GroupableParentResourceImpl<LoadBalancer, LoadBalancerInner, LoadBalancerImpl, NetworkManager>
implements LoadBalancer,
LoadBalancer.Definition,
LoadBalancer.Update {
    private final Map<String, String> nicsInBackends = new HashMap<String, String>();
    protected final Map<String, String> creatablePIPKeys = new HashMap<String, String>();
    private Map<String, LoadBalancerBackend> backends;
    private Map<String, LoadBalancerTcpProbe> tcpProbes;
    private Map<String, LoadBalancerHttpProbe> httpProbes;
    private Map<String, LoadBalancingRule> loadBalancingRules;
    private Map<String, LoadBalancerFrontend> frontends;
    private Map<String, LoadBalancerInboundNatRule> inboundNatRules;
    private Map<String, LoadBalancerInboundNatPool> inboundNatPools;

    LoadBalancerImpl(String name, LoadBalancerInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
    }

    public Observable<LoadBalancer> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<LoadBalancer, LoadBalancer>(){

            public LoadBalancer call(LoadBalancer loadBalancer) {
                LoadBalancerImpl impl = (LoadBalancerImpl)loadBalancer;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<LoadBalancerInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).loadBalancers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    protected void initializeChildrenFromInner() {
        this.initializeFrontendsFromInner();
        this.initializeProbesFromInner();
        this.initializeBackendsFromInner();
        this.initializeLoadBalancingRulesFromInner();
        this.initializeInboundNatRulesFromInner();
        this.initializeInboundNatPoolsFromInner();
    }

    protected LoadBalancerBackendImpl ensureUniqueBackend() {
        String name = SdkContext.randomResourceName((String)"backend", (int)20);
        LoadBalancerBackendImpl backend = this.defineBackend(name);
        backend.attach();
        return backend;
    }

    protected SubResource ensureFrontendRef(String name) {
        LoadBalancerFrontendImpl frontend;
        if (name == null) {
            frontend = this.ensureUniqueFrontend();
        } else {
            frontend = this.defineFrontend(name);
            frontend.attach();
        }
        return new SubResource().withId(this.futureResourceId() + "/frontendIPConfigurations/" + frontend.name());
    }

    protected LoadBalancerFrontendImpl ensureUniqueFrontend() {
        String name = SdkContext.randomResourceName((String)"frontend", (int)20);
        LoadBalancerFrontendImpl frontend = this.defineFrontend(name);
        frontend.attach();
        return frontend;
    }

    LoadBalancerPrivateFrontend findPrivateFrontendWithSubnet(String networkId, String subnetName) {
        if (null == networkId || null == subnetName) {
            return null;
        }
        for (LoadBalancerPrivateFrontend frontend : this.privateFrontends().values()) {
            if (frontend.networkId() == null || frontend.subnetName() == null || !networkId.equalsIgnoreCase(frontend.networkId()) || !subnetName.equalsIgnoreCase(frontend.subnetName())) continue;
            return frontend;
        }
        return null;
    }

    LoadBalancerPrivateFrontend ensurePrivateFrontendWithSubnet(String networkId, String subnetName) {
        LoadBalancerPrivateFrontend frontend = this.findPrivateFrontendWithSubnet(networkId, subnetName);
        if (networkId == null || subnetName == null) {
            return null;
        }
        if (frontend != null) {
            return frontend;
        }
        LoadBalancerFrontendImpl fe = this.ensureUniqueFrontend().withExistingSubnet(networkId, subnetName).withPrivateIPAddressDynamic();
        fe.attach();
        return fe;
    }

    LoadBalancerPublicFrontend ensurePublicFrontendWithPip(String pipId) {
        LoadBalancerPublicFrontend frontend = this.findFrontendByPublicIPAddress(pipId);
        if (pipId == null) {
            return null;
        }
        if (frontend != null) {
            return frontend;
        }
        LoadBalancerFrontendImpl fe = this.ensureUniqueFrontend().withExistingPublicIPAddress(pipId);
        fe.attach();
        return fe;
    }

    /*
     * WARNING - void declaration
     */
    protected void beforeCreating() {
        void var6_10;
        if (this.creatablePIPKeys != null) {
            for (Map.Entry<String, String> pipFrontendAssociation : this.creatablePIPKeys.entrySet()) {
                PublicIPAddress pip = (PublicIPAddress)this.createdResource(pipFrontendAssociation.getKey());
                if (pip == null) continue;
                this.withExistingPublicIPAddress(pip.id(), pipFrontendAssociation.getValue());
            }
            this.creatablePIPKeys.clear();
        }
        List<ProbeInner> innerProbes = this.innersFromWrappers(this.httpProbes.values());
        innerProbes = this.innersFromWrappers(this.tcpProbes.values(), innerProbes);
        if (innerProbes == null) {
            innerProbes = new ArrayList<ProbeInner>();
        }
        ((LoadBalancerInner)((Object)this.inner())).withProbes(innerProbes);
        ArrayList<BackendAddressPoolInner> innerBackends = this.innersFromWrappers(this.backends.values());
        if (null == innerBackends) {
            innerBackends = new ArrayList<BackendAddressPoolInner>();
        }
        ((LoadBalancerInner)((Object)this.inner())).withBackendAddressPools(innerBackends);
        ArrayList<FrontendIPConfigurationInner> innerFrontends = this.innersFromWrappers(this.frontends.values());
        if (null == innerFrontends) {
            innerFrontends = new ArrayList<FrontendIPConfigurationInner>();
        }
        ((LoadBalancerInner)((Object)this.inner())).withFrontendIPConfigurations(innerFrontends);
        ArrayList<InboundNatRuleInner> innerNatRules = this.innersFromWrappers(this.inboundNatRules.values());
        if (null == innerNatRules) {
            innerNatRules = new ArrayList<InboundNatRuleInner>();
        }
        ((LoadBalancerInner)((Object)this.inner())).withInboundNatRules(innerNatRules);
        for (LoadBalancerInboundNatRule loadBalancerInboundNatRule : this.inboundNatRules.values()) {
            SubResource ref = ((InboundNatRuleInner)((Object)loadBalancerInboundNatRule.inner())).frontendIPConfiguration();
            if (ref == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((InboundNatRuleInner)((Object)loadBalancerInboundNatRule.inner())).withFrontendIPConfiguration(null);
        }
        ArrayList<InboundNatPoolInner> innerNatPools = this.innersFromWrappers(this.inboundNatPools.values());
        if (null == innerNatPools) {
            innerNatPools = new ArrayList<InboundNatPoolInner>();
        }
        ((LoadBalancerInner)((Object)this.inner())).withInboundNatPools(innerNatPools);
        for (LoadBalancerInboundNatPool natPool : this.inboundNatPools.values()) {
            SubResource ref = ((InboundNatPoolInner)((Object)natPool.inner())).frontendIPConfiguration();
            if (ref == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((InboundNatPoolInner)((Object)natPool.inner())).withFrontendIPConfiguration(null);
        }
        List list = this.innersFromWrappers(this.loadBalancingRules.values());
        if (list == null) {
            ArrayList arrayList = new ArrayList();
        }
        ((LoadBalancerInner)((Object)this.inner())).withLoadBalancingRules((List<LoadBalancingRuleInner>)var6_10);
        for (LoadBalancingRule lbRule : this.loadBalancingRules.values()) {
            SubResource ref = ((LoadBalancingRuleInner)((Object)lbRule.inner())).frontendIPConfiguration();
            if (ref != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.inner())).withFrontendIPConfiguration(null);
            }
            if ((ref = ((LoadBalancingRuleInner)((Object)lbRule.inner())).backendAddressPool()) != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.inner())).withBackendAddressPool(null);
            }
            if ((ref = ((LoadBalancingRuleInner)((Object)lbRule.inner())).probe()) == null || this.httpProbes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id())) || this.tcpProbes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((LoadBalancingRuleInner)((Object)lbRule.inner())).withProbe(null);
        }
    }

    protected void afterCreating() {
        if (this.nicsInBackends != null) {
            ArrayList<Exception> nicExceptions = new ArrayList<Exception>();
            for (Map.Entry<String, String> nicInBackend : this.nicsInBackends.entrySet()) {
                String nicId = nicInBackend.getKey();
                String backendName = nicInBackend.getValue();
                try {
                    NetworkInterface nic = (NetworkInterface)((NetworkManager)this.manager()).networkInterfaces().getById(nicId);
                    NicIPConfiguration nicIP = nic.primaryIPConfiguration();
                    ((NetworkInterface.Update)((NetworkInterface.Update)nic.update()).updateIPConfiguration(nicIP.name()).withExistingLoadBalancerBackend(this, backendName).parent()).apply();
                }
                catch (Exception e) {
                    nicExceptions.add(e);
                }
            }
            if (!nicExceptions.isEmpty()) {
                throw new CompositeException(nicExceptions);
            }
            this.nicsInBackends.clear();
            this.refresh();
        }
    }

    protected Observable<LoadBalancerInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).loadBalancers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (LoadBalancerInner)((Object)this.inner()));
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, LoadBalancerFrontend>();
        List<FrontendIPConfigurationInner> frontendsInner = ((LoadBalancerInner)((Object)this.inner())).frontendIPConfigurations();
        if (frontendsInner != null) {
            for (FrontendIPConfigurationInner frontendInner : frontendsInner) {
                LoadBalancerFrontendImpl frontend = new LoadBalancerFrontendImpl(frontendInner, this);
                this.frontends.put(frontendInner.name(), frontend);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, LoadBalancerBackend>();
        List<BackendAddressPoolInner> backendsInner = ((LoadBalancerInner)((Object)this.inner())).backendAddressPools();
        if (backendsInner != null) {
            for (BackendAddressPoolInner backendInner : backendsInner) {
                LoadBalancerBackendImpl backend = new LoadBalancerBackendImpl(backendInner, this);
                this.backends.put(backendInner.name(), backend);
            }
        }
    }

    private void initializeProbesFromInner() {
        this.httpProbes = new TreeMap<String, LoadBalancerHttpProbe>();
        this.tcpProbes = new TreeMap<String, LoadBalancerTcpProbe>();
        if (((LoadBalancerInner)((Object)this.inner())).probes() != null) {
            for (ProbeInner probeInner : ((LoadBalancerInner)((Object)this.inner())).probes()) {
                LoadBalancerProbeImpl probe = new LoadBalancerProbeImpl(probeInner, this);
                if (probeInner.protocol().equals(ProbeProtocol.TCP)) {
                    this.tcpProbes.put(probeInner.name(), probe);
                    continue;
                }
                if (!probeInner.protocol().equals(ProbeProtocol.HTTP)) continue;
                this.httpProbes.put(probeInner.name(), probe);
            }
        }
    }

    private void initializeLoadBalancingRulesFromInner() {
        this.loadBalancingRules = new TreeMap<String, LoadBalancingRule>();
        List<LoadBalancingRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.inner())).loadBalancingRules();
        if (rulesInner != null) {
            for (LoadBalancingRuleInner ruleInner : rulesInner) {
                LoadBalancingRuleImpl rule = new LoadBalancingRuleImpl(ruleInner, this);
                this.loadBalancingRules.put(ruleInner.name(), rule);
            }
        }
    }

    private void initializeInboundNatPoolsFromInner() {
        this.inboundNatPools = new TreeMap<String, LoadBalancerInboundNatPool>();
        List<InboundNatPoolInner> inners = ((LoadBalancerInner)((Object)this.inner())).inboundNatPools();
        if (inners != null) {
            for (InboundNatPoolInner inner : inners) {
                LoadBalancerInboundNatPoolImpl wrapper = new LoadBalancerInboundNatPoolImpl(inner, this);
                this.inboundNatPools.put(wrapper.name(), wrapper);
            }
        }
    }

    private void initializeInboundNatRulesFromInner() {
        this.inboundNatRules = new TreeMap<String, LoadBalancerInboundNatRule>();
        List<InboundNatRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.inner())).inboundNatRules();
        if (rulesInner != null) {
            for (InboundNatRuleInner ruleInner : rulesInner) {
                LoadBalancerInboundNatRuleImpl rule = new LoadBalancerInboundNatRuleImpl(ruleInner, this);
                this.inboundNatRules.put(ruleInner.name(), rule);
            }
        }
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/loadBalancers/" + this.name();
    }

    LoadBalancerImpl withFrontend(LoadBalancerFrontendImpl frontend) {
        if (frontend != null) {
            this.frontends.put(frontend.name(), frontend);
        }
        return this;
    }

    LoadBalancerImpl withProbe(LoadBalancerProbeImpl probe) {
        if (probe == null) {
            return this;
        }
        if (probe.protocol() == ProbeProtocol.HTTP) {
            this.httpProbes.put(probe.name(), probe);
        } else if (probe.protocol() == ProbeProtocol.TCP) {
            this.tcpProbes.put(probe.name(), probe);
        }
        return this;
    }

    LoadBalancerImpl withLoadBalancingRule(LoadBalancingRuleImpl loadBalancingRule) {
        if (loadBalancingRule != null) {
            this.loadBalancingRules.put(loadBalancingRule.name(), loadBalancingRule);
        }
        return this;
    }

    LoadBalancerImpl withInboundNatRule(LoadBalancerInboundNatRuleImpl inboundNatRule) {
        if (inboundNatRule != null) {
            this.inboundNatRules.put(inboundNatRule.name(), inboundNatRule);
        }
        return this;
    }

    LoadBalancerImpl withInboundNatPool(LoadBalancerInboundNatPoolImpl inboundNatPool) {
        if (inboundNatPool != null) {
            this.inboundNatPools.put(inboundNatPool.name(), inboundNatPool);
        }
        return this;
    }

    LoadBalancerImpl withBackend(LoadBalancerBackendImpl backend) {
        if (backend != null) {
            this.backends.put(backend.name(), backend);
        }
        return this;
    }

    LoadBalancerImpl withNewPublicIPAddress(String dnsLeafLabel, String frontendName) {
        PublicIPAddress.DefinitionStages.WithGroup precreatablePIP = (PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIPAddresses().define(dnsLeafLabel)).withRegion(this.regionName());
        PublicIPAddress.DefinitionStages.WithCreate creatablePip = this.creatableGroup == null ? ((PublicIPAddress.DefinitionStages.WithCreate)precreatablePIP.withExistingResourceGroup(this.resourceGroupName())).withLeafDomainLabel(dnsLeafLabel) : ((PublicIPAddress.DefinitionStages.WithCreate)precreatablePIP.withNewResourceGroup(this.creatableGroup)).withLeafDomainLabel(dnsLeafLabel);
        return this.withNewPublicIPAddress(creatablePip, frontendName);
    }

    LoadBalancerImpl withNewPublicIPAddress(Creatable<PublicIPAddress> creatablePip, String frontendName) {
        String existingPipFrontendName = this.creatablePIPKeys.get(creatablePip.key());
        if (frontendName == null) {
            frontendName = existingPipFrontendName != null ? existingPipFrontendName : this.ensureUniqueFrontend().name();
        }
        if (existingPipFrontendName == null) {
            this.creatablePIPKeys.put(creatablePip.key(), frontendName);
            this.addCreatableDependency(creatablePip);
        } else if (!existingPipFrontendName.equalsIgnoreCase(frontendName)) {
            throw new IllegalArgumentException("This public IP address definition is already associated with a frontend under a different name.");
        }
        return this;
    }

    protected LoadBalancerImpl withExistingPublicIPAddress(String resourceId, String frontendName) {
        if (frontendName == null) {
            return (LoadBalancerImpl)this.ensureUniqueFrontend().withExistingPublicIPAddress(resourceId).parent();
        }
        return this.definePublicFrontend(frontendName).withExistingPublicIPAddress(resourceId).attach();
    }

    LoadBalancerImpl withExistingVirtualMachine(HasNetworkInterfaces vm, String backendName) {
        if (backendName != null) {
            this.defineBackend(backendName).attach();
            if (vm.primaryNetworkInterfaceId() != null) {
                this.nicsInBackends.put(vm.primaryNetworkInterfaceId(), backendName.toLowerCase());
            }
        }
        return this;
    }

    public LoadBalancerProbeImpl defineTcpProbe(String name) {
        LoadBalancerProbe probe = this.tcpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.TCP);
            return new LoadBalancerProbeImpl(inner, this);
        }
        return (LoadBalancerProbeImpl)probe;
    }

    public LoadBalancerProbeImpl defineHttpProbe(String name) {
        LoadBalancerProbe probe = this.httpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.HTTP).withPort(80);
            return new LoadBalancerProbeImpl(inner, this);
        }
        return (LoadBalancerProbeImpl)probe;
    }

    public LoadBalancingRuleImpl defineLoadBalancingRule(String name) {
        LoadBalancingRule lbRule = this.loadBalancingRules.get(name);
        if (lbRule == null) {
            LoadBalancingRuleInner inner = new LoadBalancingRuleInner().withName(name);
            return new LoadBalancingRuleImpl(inner, this);
        }
        return (LoadBalancingRuleImpl)lbRule;
    }

    public LoadBalancerInboundNatRuleImpl defineInboundNatRule(String name) {
        LoadBalancerInboundNatRule natRule = this.inboundNatRules.get(name);
        if (natRule == null) {
            InboundNatRuleInner inner = new InboundNatRuleInner().withName(name);
            return new LoadBalancerInboundNatRuleImpl(inner, this);
        }
        return (LoadBalancerInboundNatRuleImpl)natRule;
    }

    public LoadBalancerInboundNatPoolImpl defineInboundNatPool(String name) {
        LoadBalancerInboundNatPool natPool = this.inboundNatPools.get(name);
        if (natPool == null) {
            InboundNatPoolInner inner = new InboundNatPoolInner().withName(name);
            return new LoadBalancerInboundNatPoolImpl(inner, this);
        }
        return (LoadBalancerInboundNatPoolImpl)natPool;
    }

    public LoadBalancerFrontendImpl definePrivateFrontend(String name) {
        return this.defineFrontend(name);
    }

    public LoadBalancerFrontendImpl definePublicFrontend(String name) {
        return this.defineFrontend(name);
    }

    LoadBalancerFrontendImpl defineFrontend(String name) {
        LoadBalancerFrontend frontend = this.frontends.get(name);
        if (frontend == null) {
            FrontendIPConfigurationInner inner = new FrontendIPConfigurationInner().withName(name);
            return new LoadBalancerFrontendImpl(inner, this);
        }
        return (LoadBalancerFrontendImpl)frontend;
    }

    public LoadBalancerBackendImpl defineBackend(String name) {
        LoadBalancerBackend backend = this.backends.get(name);
        if (backend == null) {
            BackendAddressPoolInner inner = new BackendAddressPoolInner().withName(name);
            return new LoadBalancerBackendImpl(inner, this);
        }
        return (LoadBalancerBackendImpl)backend;
    }

    @Override
    public LoadBalancerImpl withSku(LoadBalancerSkuType skuType) {
        ((LoadBalancerInner)((Object)this.inner())).withSku(skuType.sku());
        return this;
    }

    @Override
    public LoadBalancerImpl withoutProbe(String name) {
        if (this.httpProbes.containsKey(name)) {
            this.httpProbes.remove(name);
        } else if (this.tcpProbes.containsKey(name)) {
            this.tcpProbes.remove(name);
        }
        return this;
    }

    @Override
    public LoadBalancerProbeImpl updateTcpProbe(String name) {
        return (LoadBalancerProbeImpl)this.tcpProbes.get(name);
    }

    @Override
    public LoadBalancerBackendImpl updateBackend(String name) {
        return (LoadBalancerBackendImpl)this.backends.get(name);
    }

    @Override
    public LoadBalancerFrontendImpl updatePublicFrontend(String name) {
        return (LoadBalancerFrontendImpl)this.frontends.get(name);
    }

    @Override
    public LoadBalancerFrontendImpl updatePrivateFrontend(String name) {
        return (LoadBalancerFrontendImpl)this.frontends.get(name);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl updateInboundNatRule(String name) {
        return (LoadBalancerInboundNatRuleImpl)this.inboundNatRules.get(name);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl updateInboundNatPool(String name) {
        return (LoadBalancerInboundNatPoolImpl)this.inboundNatPools.get(name);
    }

    @Override
    public LoadBalancerProbeImpl updateHttpProbe(String name) {
        return (LoadBalancerProbeImpl)this.httpProbes.get(name);
    }

    @Override
    public LoadBalancingRuleImpl updateLoadBalancingRule(String name) {
        return (LoadBalancingRuleImpl)this.loadBalancingRules.get(name);
    }

    @Override
    public LoadBalancerImpl withoutLoadBalancingRule(String name) {
        this.loadBalancingRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutInboundNatRule(String name) {
        this.inboundNatRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutBackend(String name) {
        this.backends.remove(name);
        return this;
    }

    @Override
    public LoadBalancer.Update withoutInboundNatPool(String name) {
        this.inboundNatPools.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutFrontend(String name) {
        this.frontends.remove(name);
        return this;
    }

    @Override
    public Map<String, LoadBalancerBackend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> inboundNatPools() {
        return Collections.unmodifiableMap(this.inboundNatPools);
    }

    @Override
    public LoadBalancerSkuType sku() {
        return LoadBalancerSkuType.fromSku(((LoadBalancerInner)((Object)this.inner())).sku());
    }

    @Override
    public Map<String, LoadBalancerTcpProbe> tcpProbes() {
        return Collections.unmodifiableMap(this.tcpProbes);
    }

    @Override
    public Map<String, LoadBalancerFrontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, LoadBalancerPrivateFrontend> privateFrontends() {
        HashMap<String, LoadBalancerPrivateFrontend> privateFrontends = new HashMap<String, LoadBalancerPrivateFrontend>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (frontend.isPublic()) continue;
            privateFrontends.put(frontend.name(), (LoadBalancerPrivateFrontend)frontend);
        }
        return Collections.unmodifiableMap(privateFrontends);
    }

    @Override
    public Map<String, LoadBalancerPublicFrontend> publicFrontends() {
        HashMap<String, LoadBalancerPublicFrontend> publicFrontends = new HashMap<String, LoadBalancerPublicFrontend>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            publicFrontends.put(frontend.name(), (LoadBalancerPublicFrontend)frontend);
        }
        return Collections.unmodifiableMap(publicFrontends);
    }

    @Override
    public Map<String, LoadBalancerInboundNatRule> inboundNatRules() {
        return Collections.unmodifiableMap(this.inboundNatRules);
    }

    @Override
    public Map<String, LoadBalancerHttpProbe> httpProbes() {
        return Collections.unmodifiableMap(this.httpProbes);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        return Collections.unmodifiableMap(this.loadBalancingRules);
    }

    @Override
    public List<String> publicIPAddressIds() {
        ArrayList<String> publicIPAddressIds = new ArrayList<String>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            String pipId = ((LoadBalancerPublicFrontend)frontend).publicIPAddressId();
            publicIPAddressIds.add(pipId);
        }
        return Collections.unmodifiableList(publicIPAddressIds);
    }

    @Override
    public LoadBalancerPublicFrontend findFrontendByPublicIPAddress(String pipId) {
        if (pipId == null) {
            return null;
        }
        for (LoadBalancerPublicFrontend frontend : this.publicFrontends().values()) {
            if (frontend.publicIPAddressId() == null || !pipId.equalsIgnoreCase(frontend.publicIPAddressId())) continue;
            return frontend;
        }
        return null;
    }

    @Override
    public LoadBalancerPublicFrontend findFrontendByPublicIPAddress(PublicIPAddress publicIPAddress) {
        return publicIPAddress != null ? this.findFrontendByPublicIPAddress(publicIPAddress.id()) : null;
    }
}

