/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ConnectivityCheck;
import com.microsoft.azure.management.network.FlowLogSettings;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.SecurityGroupView;
import com.microsoft.azure.management.network.Topology;
import com.microsoft.azure.management.network.implementation.ConnectivityCheckImpl;
import com.microsoft.azure.management.network.implementation.FlowLogInformationInner;
import com.microsoft.azure.management.network.implementation.FlowLogSettingsImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherInner;
import com.microsoft.azure.management.network.implementation.NextHopImpl;
import com.microsoft.azure.management.network.implementation.PacketCapturesImpl;
import com.microsoft.azure.management.network.implementation.SecurityGroupViewImpl;
import com.microsoft.azure.management.network.implementation.SecurityGroupViewResultInner;
import com.microsoft.azure.management.network.implementation.TopologyImpl;
import com.microsoft.azure.management.network.implementation.TopologyInner;
import com.microsoft.azure.management.network.implementation.VerificationIPFlowImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class NetworkWatcherImpl
extends GroupableResourceImpl<NetworkWatcher, NetworkWatcherInner, NetworkWatcherImpl, NetworkManager>
implements NetworkWatcher,
NetworkWatcher.Definition,
NetworkWatcher.Update {
    private PacketCapturesImpl packetCaptures;

    NetworkWatcherImpl(String name, NetworkWatcherInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.packetCaptures = new PacketCapturesImpl(((NetworkManagementClientImpl)((Object)networkManager.inner())).packetCaptures(), this);
    }

    @Override
    public PacketCapturesImpl packetCaptures() {
        return this.packetCaptures;
    }

    @Override
    public TopologyImpl getTopology(String targetResourceGroup) {
        TopologyInner topologyInner = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getTopology(this.resourceGroupName(), this.name(), targetResourceGroup);
        return new TopologyImpl(this, topologyInner, targetResourceGroup);
    }

    @Override
    public Observable<Topology> getTopologyAsync(final String targetResourceGroup) {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getTopologyAsync(this.resourceGroupName(), this.name(), targetResourceGroup).map((Func1)new Func1<TopologyInner, Topology>(){

            public Topology call(TopologyInner inner) {
                return new TopologyImpl(NetworkWatcherImpl.this, inner, targetResourceGroup);
            }
        });
    }

    @Override
    public SecurityGroupView getSecurityGroupView(String vmId) {
        SecurityGroupViewResultInner securityGroupViewResultInner = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getVMSecurityRules(this.resourceGroupName(), this.name(), vmId);
        return new SecurityGroupViewImpl(this, securityGroupViewResultInner, vmId);
    }

    @Override
    public Observable<SecurityGroupView> getSecurityGroupViewAsync(final String vmId) {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getVMSecurityRulesAsync(this.resourceGroupName(), this.name(), vmId).map((Func1)new Func1<SecurityGroupViewResultInner, SecurityGroupView>(){

            public SecurityGroupView call(SecurityGroupViewResultInner inner) {
                return new SecurityGroupViewImpl(NetworkWatcherImpl.this, inner, vmId);
            }
        });
    }

    @Override
    public FlowLogSettings getFlowLogSettings(String nsgId) {
        FlowLogInformationInner flowLogInformationInner = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getFlowLogStatus(this.resourceGroupName(), this.name(), nsgId);
        return new FlowLogSettingsImpl(this, flowLogInformationInner, nsgId);
    }

    @Override
    public Observable<FlowLogSettings> getFlowLogSettingsAsync(final String nsgId) {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getFlowLogStatusAsync(this.resourceGroupName(), this.name(), nsgId).map((Func1)new Func1<FlowLogInformationInner, FlowLogSettings>(){

            public FlowLogSettings call(FlowLogInformationInner inner) {
                return new FlowLogSettingsImpl(NetworkWatcherImpl.this, inner, nsgId);
            }
        });
    }

    @Override
    public NextHopImpl nextHop() {
        return new NextHopImpl(this);
    }

    @Override
    public VerificationIPFlowImpl verifyIPFlow() {
        return new VerificationIPFlowImpl(this);
    }

    @Override
    public ConnectivityCheck.DefinitionStages.ToDestination checkConnectivity() {
        return new ConnectivityCheckImpl(this);
    }

    public Observable<NetworkWatcher> createResourceAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkWatcherInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<NetworkWatcherInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkWatchers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }
}

