/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.context;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.context.core.api.CredentialSupplier;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.config.AzureProperties;
import com.microsoft.azure.spring.cloud.context.core.impl.AzureResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.impl.DefaultCredentialsProvider;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import okhttp3.Interceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AzureProperties.class})
@ConditionalOnClass(value={Azure.class})
@ConditionalOnProperty(prefix="spring.cloud.azure", value={"credential-file-path", "resource-group"})
public class AzureContextAutoConfiguration {
    private static final String PROJECT_VERSION = AzureContextAutoConfiguration.class.getPackage().getImplementationVersion();
    private static final String SPRING_CLOUD_USER_AGENT = "spring-cloud-azure/" + PROJECT_VERSION;

    @Bean
    @ConditionalOnMissingBean
    public ResourceManagerProvider resourceManagerProvider(Azure azure, AzureProperties azureProperties) {
        return new AzureResourceManagerProvider(azure, azureProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Azure azure(AzureProperties azureProperties) throws IOException {
        DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider((CredentialSupplier)azureProperties);
        ApplicationTokenCredentials credentials = credentialsProvider.getCredentials();
        TelemetryCollector.getInstance().setSubscription(credentials.defaultSubscriptionId());
        RestClient restClient = new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor((AzureTokenCredentials)credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).withUserAgent(SPRING_CLOUD_USER_AGENT).build();
        return Azure.authenticate((RestClient)restClient, (String)credentials.domain()).withDefaultSubscription();
    }
}

