/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.eventhub;

import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.eventhub.AzureEventHubProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.eventhub.EventHubUtils;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.context.core.api.Environment;
import com.microsoft.azure.spring.cloud.context.core.api.EnvironmentProvider;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.storage.StorageConnectionStringProvider;
import com.microsoft.azure.spring.integration.eventhub.api.EventHubClientFactory;
import com.microsoft.azure.spring.integration.eventhub.api.EventHubOperation;
import com.microsoft.azure.spring.integration.eventhub.factory.DefaultEventHubClientFactory;
import com.microsoft.azure.spring.integration.eventhub.factory.EventHubConnectionStringProvider;
import com.microsoft.azure.spring.integration.eventhub.impl.EventHubTemplate;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnClass(value={EventHubClient.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhub.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureEventHubProperties.class})
public class AzureEventHubAutoConfiguration {
    private static final String EVENT_HUB = "EventHub";
    private static final String NAMESPACE = "Namespace";
    @Autowired(required=false)
    private ResourceManagerProvider resourceManagerProvider;

    @PostConstruct
    public void collectTelemetry() {
        TelemetryCollector.getInstance().addService(EVENT_HUB);
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubOperation eventHubOperation(EventHubClientFactory clientFactory) {
        return new EventHubTemplate(clientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubConnectionStringProvider eventHubConnectionStringProvider(AzureEventHubProperties eventHubProperties) {
        if (this.resourceManagerProvider != null) {
            EventHubNamespace namespace = (EventHubNamespace)this.resourceManagerProvider.getEventHubNamespaceManager().getOrCreate((Object)eventHubProperties.getNamespace());
            return new EventHubConnectionStringProvider(namespace);
        }
        String connectionString = eventHubProperties.getConnectionString();
        TelemetryCollector.getInstance().addProperty(EVENT_HUB, NAMESPACE, EventHubUtils.getNamespace(connectionString));
        return new EventHubConnectionStringProvider(connectionString);
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubClientFactory clientFactory(EventHubConnectionStringProvider connectionStringProvider, AzureEventHubProperties eventHubProperties, EnvironmentProvider environmentProvider) {
        String checkpointConnectionString;
        if (this.resourceManagerProvider != null) {
            StorageAccount checkpointStorageAccount = (StorageAccount)this.resourceManagerProvider.getStorageAccountManager().getOrCreate((Object)eventHubProperties.getCheckpointStorageAccount());
            checkpointConnectionString = StorageConnectionStringProvider.getConnectionString((StorageAccount)checkpointStorageAccount, (Environment)environmentProvider.getEnvironment());
        } else {
            checkpointConnectionString = StorageConnectionStringProvider.getConnectionString((String)eventHubProperties.getCheckpointStorageAccount(), (String)eventHubProperties.getCheckpointAccessKey(), (Environment)environmentProvider.getEnvironment());
        }
        return new DefaultEventHubClientFactory(connectionStringProvider, checkpointConnectionString);
    }
}

