/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.eventhub;

import javax.annotation.PostConstruct;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.cloud.azure.eventhub")
public class AzureEventHubProperties {
    private String namespace;
    private String connectionString;
    @Pattern(regexp="^[a-z0-9]{3,24}$", message="must be between 3 and 24 characters in length and use numbers and lower-case letters only")
    private @Pattern(regexp="^[a-z0-9]{3,24}$", message="must be between 3 and 24 characters in length and use numbers and lower-case letters only") String checkpointStorageAccount;
    private String checkpointAccessKey;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getCheckpointStorageAccount() {
        return this.checkpointStorageAccount;
    }

    public void setCheckpointStorageAccount(String checkpointStorageAccount) {
        this.checkpointStorageAccount = checkpointStorageAccount;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getCheckpointAccessKey() {
        return this.checkpointAccessKey;
    }

    public void setCheckpointAccessKey(String checkpointAccessKey) {
        this.checkpointAccessKey = checkpointAccessKey;
    }

    @PostConstruct
    public void validate() {
        if (!StringUtils.hasText((String)this.namespace) && !StringUtils.hasText((String)this.connectionString)) {
            throw new IllegalArgumentException("Either 'spring.cloud.azure.eventhub.namespace' or 'spring.cloud.azure.eventhub.connection-string' should be provided");
        }
    }
}

