/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.servicebus;

import com.microsoft.azure.management.servicebus.AuthorizationKeys;
import com.microsoft.azure.management.servicebus.AuthorizationRule;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.servicebus.AzureServiceBusProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManager;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnClass(value={IMessage.class})
@ConditionalOnProperty(value={"spring.cloud.azure.servicebus.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureServiceBusProperties.class})
public class AzureServiceBusAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AzureServiceBusAutoConfiguration.class);
    private static final String SERVICE_BUS = "ServiceBus";

    private static String buildConnectionString(ResourceManager<ServiceBusNamespace, String> serviceBusNamespaceManager, String namespace) {
        return ((ServiceBusNamespace)serviceBusNamespaceManager.getOrCreate((Object)namespace)).authorizationRules().list().stream().findFirst().map(AuthorizationRule::getKeys).map(AuthorizationKeys::primaryConnectionString).map(s -> new ConnectionStringBuilder(s, namespace).toString()).orElseThrow(() -> new RuntimeException(String.format("Service bus namespace '%s' key is empty", namespace), null));
    }

    @PostConstruct
    public void collectTelemetry() {
        TelemetryCollector.getInstance().addService(SERVICE_BUS);
    }

    @Bean
    @ConditionalOnBean(value={ResourceManagerProvider.class})
    public AzureServiceBusProperties serviceBusProperties(ResourceManagerProvider resourceManagerProvider, AzureServiceBusProperties serviceBusProperties) {
        if (!StringUtils.hasText((String)serviceBusProperties.getConnectionString())) {
            ResourceManager serviceBusNamespaceManager = resourceManagerProvider.getServiceBusNamespaceManager();
            serviceBusNamespaceManager.getOrCreate((Object)serviceBusProperties.getNamespace());
            serviceBusProperties.setConnectionString(AzureServiceBusAutoConfiguration.buildConnectionString((ResourceManager<ServiceBusNamespace, String>)resourceManagerProvider.getServiceBusNamespaceManager(), serviceBusProperties.getNamespace()));
            log.info("'spring.cloud.azure.servicebus.connection-string' auto configured");
        }
        return serviceBusProperties;
    }
}

