/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryEventData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TelemetryRestClient {
    private static final Logger log = LoggerFactory.getLogger(TelemetryRestClient.class);
    private static final String TELEMETRY_TARGET_URL = "https://dc.services.visualstudio.com/v2/track";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final HttpHeaders HEADERS = new HttpHeaders();
    private static final RestTemplate REST_TEMPLATE = new RestTemplate();
    private static final int RETRY_LIMIT = 3;
    private final String instrumentKey;

    public TelemetryRestClient(String instrumentKey) {
        Assert.hasText((String)instrumentKey, (String)"Instrument key should have text.");
        this.instrumentKey = instrumentKey;
    }

    private boolean sendTelemetryData(TelemetryEventData eventData) {
        try {
            HttpEntity body = new HttpEntity((Object)MAPPER.writeValueAsString((Object)eventData), (MultiValueMap)HEADERS);
            ResponseEntity response = REST_TEMPLATE.exchange(TELEMETRY_TARGET_URL, HttpMethod.POST, body, String.class, new Object[0]);
            return response.getStatusCode() == HttpStatus.OK;
        }
        catch (Exception ignore) {
            log.warn("Failed to exchange telemetry request, {}.", (Object)ignore.getMessage());
            return false;
        }
    }

    public void send(@NonNull String eventName, @NonNull Map<String, String> properties) {
        Assert.hasText((String)eventName, (String)"Event name should have text.");
        for (int i = 0; i < 3; ++i) {
            if (!this.sendTelemetryData(new TelemetryEventData(eventName, properties, this.instrumentKey))) continue;
            return;
        }
        log.warn("Failed to send telemetry data");
    }

    static {
        HEADERS.add("Content-Type", MimeTypeUtils.APPLICATION_JSON.toString());
    }
}

