/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See LICENSE in the project root for
 * license information.
 */

package com.microsoft.azure.servicebus.stream.binder.properties;

import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;

/**
 * @author Warren Zhu
 */
public class ServiceBusBindingProperties implements BinderSpecificPropertiesProvider {
    private ServiceBusConsumerProperties consumer = new ServiceBusConsumerProperties();
    private ServiceBusProducerProperties producer = new ServiceBusProducerProperties();

    public ServiceBusConsumerProperties getConsumer() {
        return consumer;
    }

    public void setConsumer(ServiceBusConsumerProperties consumer) {
        this.consumer = consumer;
    }

    public ServiceBusProducerProperties getProducer() {
        return producer;
    }

    public void setProducer(ServiceBusProducerProperties producer) {
        this.producer = producer;
    }
}
