// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ItemReference;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Copy To Default Content Location Parameter Set.
 */
public class ContentTypeCopyToDefaultContentLocationParameterSet {
    /**
     * The source File.
     * 
     */
    @SerializedName(value = "sourceFile", alternate = {"SourceFile"})
    @Expose
	@Nullable
    public ItemReference sourceFile;

    /**
     * The destination File Name.
     * 
     */
    @SerializedName(value = "destinationFileName", alternate = {"DestinationFileName"})
    @Expose
	@Nullable
    public String destinationFileName;


    /**
     * Instiaciates a new ContentTypeCopyToDefaultContentLocationParameterSet
     */
    public ContentTypeCopyToDefaultContentLocationParameterSet() {}
    /**
     * Instiaciates a new ContentTypeCopyToDefaultContentLocationParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ContentTypeCopyToDefaultContentLocationParameterSet(@Nonnull final ContentTypeCopyToDefaultContentLocationParameterSetBuilder builder) {
        this.sourceFile = builder.sourceFile;
        this.destinationFileName = builder.destinationFileName;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ContentTypeCopyToDefaultContentLocationParameterSetBuilder newBuilder() {
        return new ContentTypeCopyToDefaultContentLocationParameterSetBuilder();
    }
    /**
     * Fluent builder for the ContentTypeCopyToDefaultContentLocationParameterSet
     */
    public static final class ContentTypeCopyToDefaultContentLocationParameterSetBuilder {
        /**
         * The sourceFile parameter value
         */
        @Nullable
        protected ItemReference sourceFile;
        /**
         * Sets the SourceFile
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ContentTypeCopyToDefaultContentLocationParameterSetBuilder withSourceFile(@Nullable final ItemReference val) {
            this.sourceFile = val;
            return this;
        }
        /**
         * The destinationFileName parameter value
         */
        @Nullable
        protected String destinationFileName;
        /**
         * Sets the DestinationFileName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ContentTypeCopyToDefaultContentLocationParameterSetBuilder withDestinationFileName(@Nullable final String val) {
            this.destinationFileName = val;
            return this;
        }
        /**
         * Instanciates a new ContentTypeCopyToDefaultContentLocationParameterSetBuilder
         */
        @Nullable
        protected ContentTypeCopyToDefaultContentLocationParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ContentTypeCopyToDefaultContentLocationParameterSet build() {
            return new ContentTypeCopyToDefaultContentLocationParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.sourceFile != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sourceFile", sourceFile));
        }
        if(this.destinationFileName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("destinationFileName", destinationFileName));
        }
        return result;
    }
}
