// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.UserAttributeValuesItem;
import com.microsoft.graph.models.IdentityUserFlowAttributeInputType;
import com.microsoft.graph.models.IdentityUserFlowAttribute;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Attribute Assignment.
 */
public class IdentityUserFlowAttributeAssignment extends Entity implements IJsonBackedObject {


    /**
     * The Display Name.
     * The display name of the identityUserFlowAttribute within a user flow.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Optional.
     * Determines whether the identityUserFlowAttribute is optional. true means the user doesn't have to provide a value. false means the user cannot complete sign-up without providing a value.
     */
    @SerializedName(value = "isOptional", alternate = {"IsOptional"})
    @Expose
	@Nullable
    public Boolean isOptional;

    /**
     * The Requires Verification.
     * Determines whether the identityUserFlowAttribute requires verification. This is only used for verifying the user's phone number or email address.
     */
    @SerializedName(value = "requiresVerification", alternate = {"RequiresVerification"})
    @Expose
	@Nullable
    public Boolean requiresVerification;

    /**
     * The User Attribute Values.
     * The input options for the user flow attribute. Only applicable when the userInputType is radioSingleSelect, dropdownSingleSelect, or checkboxMultiSelect.
     */
    @SerializedName(value = "userAttributeValues", alternate = {"UserAttributeValues"})
    @Expose
	@Nullable
    public java.util.List<UserAttributeValuesItem> userAttributeValues;

    /**
     * The User Input Type.
     * The input type of the user flow attribute. Possible values are: textBox, dateTimeDropdown, radioSingleSelect, dropdownSingleSelect, emailBox, checkboxMultiSelect.
     */
    @SerializedName(value = "userInputType", alternate = {"UserInputType"})
    @Expose
	@Nullable
    public IdentityUserFlowAttributeInputType userInputType;

    /**
     * The User Attribute.
     * The user attribute that you want to add to your user flow.
     */
    @SerializedName(value = "userAttribute", alternate = {"UserAttribute"})
    @Expose
	@Nullable
    public IdentityUserFlowAttribute userAttribute;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
