// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Message;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Create Reply All Parameter Set.
 */
public class MessageCreateReplyAllParameterSet {
    /**
     * The message.
     * 
     */
    @SerializedName(value = "message", alternate = {"Message"})
    @Expose
	@Nullable
    public Message message;

    /**
     * The comment.
     * 
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;


    /**
     * Instiaciates a new MessageCreateReplyAllParameterSet
     */
    public MessageCreateReplyAllParameterSet() {}
    /**
     * Instiaciates a new MessageCreateReplyAllParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected MessageCreateReplyAllParameterSet(@Nonnull final MessageCreateReplyAllParameterSetBuilder builder) {
        this.message = builder.message;
        this.comment = builder.comment;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static MessageCreateReplyAllParameterSetBuilder newBuilder() {
        return new MessageCreateReplyAllParameterSetBuilder();
    }
    /**
     * Fluent builder for the MessageCreateReplyAllParameterSet
     */
    public static final class MessageCreateReplyAllParameterSetBuilder {
        /**
         * The message parameter value
         */
        @Nullable
        protected Message message;
        /**
         * Sets the Message
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public MessageCreateReplyAllParameterSetBuilder withMessage(@Nullable final Message val) {
            this.message = val;
            return this;
        }
        /**
         * The comment parameter value
         */
        @Nullable
        protected String comment;
        /**
         * Sets the Comment
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public MessageCreateReplyAllParameterSetBuilder withComment(@Nullable final String val) {
            this.comment = val;
            return this;
        }
        /**
         * Instanciates a new MessageCreateReplyAllParameterSetBuilder
         */
        @Nullable
        protected MessageCreateReplyAllParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public MessageCreateReplyAllParameterSet build() {
            return new MessageCreateReplyAllParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.message != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("message", message));
        }
        if(this.comment != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("comment", comment));
        }
        return result;
    }
}
