// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Edate Parameter Set.
 */
public class WorkbookFunctionsEdateParameterSet {
    /**
     * The start Date.
     * 
     */
    @SerializedName(value = "startDate", alternate = {"StartDate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startDate;

    /**
     * The months.
     * 
     */
    @SerializedName(value = "months", alternate = {"Months"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement months;


    /**
     * Instiaciates a new WorkbookFunctionsEdateParameterSet
     */
    public WorkbookFunctionsEdateParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsEdateParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsEdateParameterSet(@Nonnull final WorkbookFunctionsEdateParameterSetBuilder builder) {
        this.startDate = builder.startDate;
        this.months = builder.months;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsEdateParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsEdateParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsEdateParameterSet
     */
    public static final class WorkbookFunctionsEdateParameterSetBuilder {
        /**
         * The startDate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startDate;
        /**
         * Sets the StartDate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEdateParameterSetBuilder withStartDate(@Nullable final com.google.gson.JsonElement val) {
            this.startDate = val;
            return this;
        }
        /**
         * The months parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement months;
        /**
         * Sets the Months
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEdateParameterSetBuilder withMonths(@Nullable final com.google.gson.JsonElement val) {
            this.months = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsEdateParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsEdateParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsEdateParameterSet build() {
            return new WorkbookFunctionsEdateParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startDate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDate", startDate));
        }
        if(this.months != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("months", months));
        }
        return result;
    }
}
