// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContactFolder;
import com.microsoft.graph.requests.ContactFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.ContactFolderRequestBuilder;
import com.microsoft.graph.requests.ContactCollectionRequestBuilder;
import com.microsoft.graph.requests.ContactRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Contact Folder Request.
 */
public class ContactFolderRequest extends BaseRequest<ContactFolder> {
	
    /**
     * The request for the ContactFolder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContactFolderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContactFolder.class);
    }

    /**
     * Gets the ContactFolder from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContactFolder> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ContactFolder from the service
     *
     * @return the ContactFolder from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContactFolder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContactFolder> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ContactFolder delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ContactFolder with a source
     *
     * @param sourceContactFolder the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContactFolder> patchAsync(@Nonnull final ContactFolder sourceContactFolder) {
        return sendAsync(HttpMethod.PATCH, sourceContactFolder);
    }

    /**
     * Patches this ContactFolder with a source
     *
     * @param sourceContactFolder the source object with updates
     * @return the updated ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContactFolder patch(@Nonnull final ContactFolder sourceContactFolder) throws ClientException {
        return send(HttpMethod.PATCH, sourceContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContactFolder> postAsync(@Nonnull final ContactFolder newContactFolder) {
        return sendAsync(HttpMethod.POST, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the new object to create
     * @return the created ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContactFolder post(@Nonnull final ContactFolder newContactFolder) throws ClientException {
        return send(HttpMethod.POST, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContactFolder> putAsync(@Nonnull final ContactFolder newContactFolder) {
        return sendAsync(HttpMethod.PUT, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the object to create/update
     * @return the created ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContactFolder put(@Nonnull final ContactFolder newContactFolder) throws ClientException {
        return send(HttpMethod.PUT, newContactFolder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ContactFolderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ContactFolderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

