// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Event;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.EventDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.EventDeltaCollectionPage;
import com.microsoft.graph.requests.EventDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Delta Collection Page.
 */
public class EventDeltaCollectionPage extends DeltaCollectionPage<Event, EventDeltaCollectionRequestBuilder> {

    /**
     * A collection page for Event.
     *
     * @param response The serialized EventDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public EventDeltaCollectionPage(@Nonnull final EventDeltaCollectionResponse response, @Nonnull final EventDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for EventDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public EventDeltaCollectionPage(@Nonnull final java.util.List<Event> pageContents, @Nullable final EventDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
