// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityProtectionRoot;
import com.microsoft.graph.requests.RiskDetectionCollectionRequestBuilder;
import com.microsoft.graph.requests.RiskDetectionRequestBuilder;
import com.microsoft.graph.requests.RiskyUserCollectionRequestBuilder;
import com.microsoft.graph.requests.RiskyUserRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Protection Root Request.
 */
public class IdentityProtectionRootRequest extends BaseRequest<IdentityProtectionRoot> {
	
    /**
     * The request for the IdentityProtectionRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProtectionRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProtectionRoot.class);
    }

    /**
     * Gets the IdentityProtectionRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProtectionRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityProtectionRoot from the service
     *
     * @return the IdentityProtectionRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProtectionRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProtectionRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityProtectionRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityProtectionRoot with a source
     *
     * @param sourceIdentityProtectionRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProtectionRoot> patchAsync(@Nonnull final IdentityProtectionRoot sourceIdentityProtectionRoot) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityProtectionRoot);
    }

    /**
     * Patches this IdentityProtectionRoot with a source
     *
     * @param sourceIdentityProtectionRoot the source object with updates
     * @return the updated IdentityProtectionRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProtectionRoot patch(@Nonnull final IdentityProtectionRoot sourceIdentityProtectionRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityProtectionRoot);
    }

    /**
     * Creates a IdentityProtectionRoot with a new object
     *
     * @param newIdentityProtectionRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProtectionRoot> postAsync(@Nonnull final IdentityProtectionRoot newIdentityProtectionRoot) {
        return sendAsync(HttpMethod.POST, newIdentityProtectionRoot);
    }

    /**
     * Creates a IdentityProtectionRoot with a new object
     *
     * @param newIdentityProtectionRoot the new object to create
     * @return the created IdentityProtectionRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProtectionRoot post(@Nonnull final IdentityProtectionRoot newIdentityProtectionRoot) throws ClientException {
        return send(HttpMethod.POST, newIdentityProtectionRoot);
    }

    /**
     * Creates a IdentityProtectionRoot with a new object
     *
     * @param newIdentityProtectionRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProtectionRoot> putAsync(@Nonnull final IdentityProtectionRoot newIdentityProtectionRoot) {
        return sendAsync(HttpMethod.PUT, newIdentityProtectionRoot);
    }

    /**
     * Creates a IdentityProtectionRoot with a new object
     *
     * @param newIdentityProtectionRoot the object to create/update
     * @return the created IdentityProtectionRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProtectionRoot put(@Nonnull final IdentityProtectionRoot newIdentityProtectionRoot) throws ClientException {
        return send(HttpMethod.PUT, newIdentityProtectionRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityProtectionRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityProtectionRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

