// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;

import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.IdentityProviderBaseAvailableProviderTypesCollectionRequestBuilder;
import com.microsoft.graph.requests.IdentityProviderBaseAvailableProviderTypesCollectionRequest;
import com.microsoft.graph.requests.IdentityProviderBaseAvailableProviderTypesCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider Base Available Provider Types Collection Request Builder.
 */
public class IdentityProviderBaseAvailableProviderTypesCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<String, IdentityProviderBaseAvailableProviderTypesCollectionRequestBuilder, IdentityProviderBaseAvailableProviderTypesCollectionResponse, IdentityProviderBaseAvailableProviderTypesCollectionPage, IdentityProviderBaseAvailableProviderTypesCollectionRequest> {

    /**
     * The request builder for this collection of IdentityProviderBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProviderBaseAvailableProviderTypesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderBaseAvailableProviderTypesCollectionRequestBuilder.class, IdentityProviderBaseAvailableProviderTypesCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IdentityProviderBaseAvailableProviderTypesCollectionRequest instance
     */
    @Override
    @Nonnull
    public IdentityProviderBaseAvailableProviderTypesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final IdentityProviderBaseAvailableProviderTypesCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
