// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedIOSLobApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed IOSLob App Request.
 */
public class ManagedIOSLobAppRequest extends BaseRequest<ManagedIOSLobApp> {
	
    /**
     * The request for the ManagedIOSLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedIOSLobAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedIOSLobApp.class);
    }

    /**
     * Gets the ManagedIOSLobApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedIOSLobApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedIOSLobApp from the service
     *
     * @return the ManagedIOSLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedIOSLobApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedIOSLobApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedIOSLobApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedIOSLobApp with a source
     *
     * @param sourceManagedIOSLobApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedIOSLobApp> patchAsync(@Nonnull final ManagedIOSLobApp sourceManagedIOSLobApp) {
        return sendAsync(HttpMethod.PATCH, sourceManagedIOSLobApp);
    }

    /**
     * Patches this ManagedIOSLobApp with a source
     *
     * @param sourceManagedIOSLobApp the source object with updates
     * @return the updated ManagedIOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedIOSLobApp patch(@Nonnull final ManagedIOSLobApp sourceManagedIOSLobApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedIOSLobApp);
    }

    /**
     * Creates a ManagedIOSLobApp with a new object
     *
     * @param newManagedIOSLobApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedIOSLobApp> postAsync(@Nonnull final ManagedIOSLobApp newManagedIOSLobApp) {
        return sendAsync(HttpMethod.POST, newManagedIOSLobApp);
    }

    /**
     * Creates a ManagedIOSLobApp with a new object
     *
     * @param newManagedIOSLobApp the new object to create
     * @return the created ManagedIOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedIOSLobApp post(@Nonnull final ManagedIOSLobApp newManagedIOSLobApp) throws ClientException {
        return send(HttpMethod.POST, newManagedIOSLobApp);
    }

    /**
     * Creates a ManagedIOSLobApp with a new object
     *
     * @param newManagedIOSLobApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedIOSLobApp> putAsync(@Nonnull final ManagedIOSLobApp newManagedIOSLobApp) {
        return sendAsync(HttpMethod.PUT, newManagedIOSLobApp);
    }

    /**
     * Creates a ManagedIOSLobApp with a new object
     *
     * @param newManagedIOSLobApp the object to create/update
     * @return the created ManagedIOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedIOSLobApp put(@Nonnull final ManagedIOSLobApp newManagedIOSLobApp) throws ClientException {
        return send(HttpMethod.PUT, newManagedIOSLobApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedIOSLobAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedIOSLobAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

