// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SharedDriveItem;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.ListRequestBuilder;
import com.microsoft.graph.requests.ListItemRequestBuilder;
import com.microsoft.graph.requests.PermissionRequestBuilder;
import com.microsoft.graph.requests.SiteRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Drive Item Request.
 */
public class SharedDriveItemRequest extends BaseRequest<SharedDriveItem> {
	
    /**
     * The request for the SharedDriveItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharedDriveItemRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedDriveItem.class);
    }

    /**
     * Gets the SharedDriveItem from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedDriveItem> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SharedDriveItem from the service
     *
     * @return the SharedDriveItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedDriveItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedDriveItem> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SharedDriveItem delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SharedDriveItem with a source
     *
     * @param sourceSharedDriveItem the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedDriveItem> patchAsync(@Nonnull final SharedDriveItem sourceSharedDriveItem) {
        return sendAsync(HttpMethod.PATCH, sourceSharedDriveItem);
    }

    /**
     * Patches this SharedDriveItem with a source
     *
     * @param sourceSharedDriveItem the source object with updates
     * @return the updated SharedDriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedDriveItem patch(@Nonnull final SharedDriveItem sourceSharedDriveItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     *
     * @param newSharedDriveItem the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedDriveItem> postAsync(@Nonnull final SharedDriveItem newSharedDriveItem) {
        return sendAsync(HttpMethod.POST, newSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     *
     * @param newSharedDriveItem the new object to create
     * @return the created SharedDriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedDriveItem post(@Nonnull final SharedDriveItem newSharedDriveItem) throws ClientException {
        return send(HttpMethod.POST, newSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     *
     * @param newSharedDriveItem the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedDriveItem> putAsync(@Nonnull final SharedDriveItem newSharedDriveItem) {
        return sendAsync(HttpMethod.PUT, newSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     *
     * @param newSharedDriveItem the object to create/update
     * @return the created SharedDriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedDriveItem put(@Nonnull final SharedDriveItem newSharedDriveItem) throws ClientException {
        return send(HttpMethod.PUT, newSharedDriveItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SharedDriveItemRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SharedDriveItemRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

