// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SubjectRightsRequest;
import com.microsoft.graph.requests.AuthoredNoteCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthoredNoteRequestBuilder;
import com.microsoft.graph.requests.TeamWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subject Rights Request Request.
 */
public class SubjectRightsRequestRequest extends BaseRequest<SubjectRightsRequest> {
	
    /**
     * The request for the SubjectRightsRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubjectRightsRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubjectRightsRequest.class);
    }

    /**
     * Gets the SubjectRightsRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SubjectRightsRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SubjectRightsRequest from the service
     *
     * @return the SubjectRightsRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SubjectRightsRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SubjectRightsRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SubjectRightsRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SubjectRightsRequest with a source
     *
     * @param sourceSubjectRightsRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SubjectRightsRequest> patchAsync(@Nonnull final SubjectRightsRequest sourceSubjectRightsRequest) {
        return sendAsync(HttpMethod.PATCH, sourceSubjectRightsRequest);
    }

    /**
     * Patches this SubjectRightsRequest with a source
     *
     * @param sourceSubjectRightsRequest the source object with updates
     * @return the updated SubjectRightsRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SubjectRightsRequest patch(@Nonnull final SubjectRightsRequest sourceSubjectRightsRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceSubjectRightsRequest);
    }

    /**
     * Creates a SubjectRightsRequest with a new object
     *
     * @param newSubjectRightsRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SubjectRightsRequest> postAsync(@Nonnull final SubjectRightsRequest newSubjectRightsRequest) {
        return sendAsync(HttpMethod.POST, newSubjectRightsRequest);
    }

    /**
     * Creates a SubjectRightsRequest with a new object
     *
     * @param newSubjectRightsRequest the new object to create
     * @return the created SubjectRightsRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SubjectRightsRequest post(@Nonnull final SubjectRightsRequest newSubjectRightsRequest) throws ClientException {
        return send(HttpMethod.POST, newSubjectRightsRequest);
    }

    /**
     * Creates a SubjectRightsRequest with a new object
     *
     * @param newSubjectRightsRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SubjectRightsRequest> putAsync(@Nonnull final SubjectRightsRequest newSubjectRightsRequest) {
        return sendAsync(HttpMethod.PUT, newSubjectRightsRequest);
    }

    /**
     * Creates a SubjectRightsRequest with a new object
     *
     * @param newSubjectRightsRequest the object to create/update
     * @return the created SubjectRightsRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SubjectRightsRequest put(@Nonnull final SubjectRightsRequest newSubjectRightsRequest) throws ClientException {
        return send(HttpMethod.PUT, newSubjectRightsRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SubjectRightsRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SubjectRightsRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

