// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ConsentRequestFilterByCurrentUserOptions;
import com.microsoft.graph.models.UserConsentRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.UserConsentRequestFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.UserConsentRequestFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.UserConsentRequestFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.UserConsentRequestFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Consent Request Filter By Current User Collection Request Builder.
 */
public class UserConsentRequestFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<UserConsentRequest, UserConsentRequestFilterByCurrentUserCollectionRequestBuilder, UserConsentRequestFilterByCurrentUserCollectionResponse, UserConsentRequestFilterByCurrentUserCollectionPage, UserConsentRequestFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of UserConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserConsentRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserConsentRequestFilterByCurrentUserCollectionRequestBuilder.class, UserConsentRequestFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of UserConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public UserConsentRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final UserConsentRequestFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, UserConsentRequestFilterByCurrentUserCollectionRequestBuilder.class, UserConsentRequestFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UserConsentRequestFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public UserConsentRequestFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UserConsentRequestFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
