// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.termstore.models.TermGroupScope;
import com.microsoft.graph.termstore.models.Set;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.termstore.requests.SetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group.
 */
public class Group extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * Date and time of the group creation. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * Description that gives details on the term usage.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Name of the group.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Parent Site Id.
     * ID of the parent site of this group.
     */
    @SerializedName(value = "parentSiteId", alternate = {"ParentSiteId"})
    @Expose
	@Nullable
    public String parentSiteId;

    /**
     * The Scope.
     * Returns the type of the group. Possible values are global, system, and siteCollection.
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
	@Nullable
    public TermGroupScope scope;

    /**
     * The Sets.
     * All sets under the group in a term [store].
     */
    @SerializedName(value = "sets", alternate = {"Sets"})
    @Expose
	@Nullable
    public SetCollectionPage sets;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("sets")) {
            sets = serializer.deserializeObject(json.get("sets"), SetCollectionPage.class);
        }
    }
}
