// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.termstore.models.Group;
import com.microsoft.graph.termstore.models.Set;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.termstore.requests.GroupCollectionPage;
import com.microsoft.graph.termstore.requests.SetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Store.
 */
public class Store extends Entity implements IJsonBackedObject {


    /**
     * The Default Language Tag.
     * Default language of the term store.
     */
    @SerializedName(value = "defaultLanguageTag", alternate = {"DefaultLanguageTag"})
    @Expose
	@Nullable
    public String defaultLanguageTag;

    /**
     * The Language Tags.
     * List of languages for the term store.
     */
    @SerializedName(value = "languageTags", alternate = {"LanguageTags"})
    @Expose
	@Nullable
    public java.util.List<String> languageTags;

    /**
     * The Groups.
     * Collection of all groups available in the term store.
     */
    @SerializedName(value = "groups", alternate = {"Groups"})
    @Expose
	@Nullable
    public GroupCollectionPage groups;

    /**
     * The Sets.
     * Collection of all sets available in the term store.
     */
    @SerializedName(value = "sets", alternate = {"Sets"})
    @Expose
	@Nullable
    public SetCollectionPage sets;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("groups")) {
            groups = serializer.deserializeObject(json.get("groups"), GroupCollectionPage.class);
        }

        if (json.has("sets")) {
            sets = serializer.deserializeObject(json.get("sets"), SetCollectionPage.class);
        }
    }
}
