// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AppliedConditionalAccessPolicyResult;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Applied Conditional Access Policy.
 */
public class AppliedConditionalAccessPolicy implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Display Name.
     * Refers to the Name of the conditional access policy (example: 'Require MFA for Salesforce').
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Enforced Grant Controls.
     * Refers to the grant controls enforced by the conditional access policy (example: 'Require multi-factor authentication').
     */
    @SerializedName(value = "enforcedGrantControls", alternate = {"EnforcedGrantControls"})
    @Expose
	@Nullable
    public java.util.List<String> enforcedGrantControls;

    /**
     * The Enforced Session Controls.
     * Refers to the session controls enforced by the conditional access policy (example: 'Require app enforced controls').
     */
    @SerializedName(value = "enforcedSessionControls", alternate = {"EnforcedSessionControls"})
    @Expose
	@Nullable
    public java.util.List<String> enforcedSessionControls;

    /**
     * The Id.
     * An identifier of the conditional access policy.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Result.
     * Indicates the result of the CA policy that was triggered. Possible values are: success, failure, notApplied (Policy isn't applied because policy conditions were not met),notEnabled (This is due to the policy in disabled state), unknown, unknownFutureValue.
     */
    @SerializedName(value = "result", alternate = {"Result"})
    @Expose
	@Nullable
    public AppliedConditionalAccessPolicyResult result;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
