// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the EBook Install Summary.
 */
public class EBookInstallSummary extends Entity implements IJsonBackedObject {


    /**
     * The Failed Device Count.
     * Number of Devices that have failed to install this book.
     */
    @SerializedName(value = "failedDeviceCount", alternate = {"FailedDeviceCount"})
    @Expose
	@Nullable
    public Integer failedDeviceCount;

    /**
     * The Failed User Count.
     * Number of Users that have 1 or more device that failed to install this book.
     */
    @SerializedName(value = "failedUserCount", alternate = {"FailedUserCount"})
    @Expose
	@Nullable
    public Integer failedUserCount;

    /**
     * The Installed Device Count.
     * Number of Devices that have successfully installed this book.
     */
    @SerializedName(value = "installedDeviceCount", alternate = {"InstalledDeviceCount"})
    @Expose
	@Nullable
    public Integer installedDeviceCount;

    /**
     * The Installed User Count.
     * Number of Users whose devices have all succeeded to install this book.
     */
    @SerializedName(value = "installedUserCount", alternate = {"InstalledUserCount"})
    @Expose
	@Nullable
    public Integer installedUserCount;

    /**
     * The Not Installed Device Count.
     * Number of Devices that does not have this book installed.
     */
    @SerializedName(value = "notInstalledDeviceCount", alternate = {"NotInstalledDeviceCount"})
    @Expose
	@Nullable
    public Integer notInstalledDeviceCount;

    /**
     * The Not Installed User Count.
     * Number of Users that did not install this book.
     */
    @SerializedName(value = "notInstalledUserCount", alternate = {"NotInstalledUserCount"})
    @Expose
	@Nullable
    public Integer notInstalledUserCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
