// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Application Calculate Parameter Set.
 */
public class WorkbookApplicationCalculateParameterSet {
    /**
     * The calculation Type.
     * 
     */
    @SerializedName(value = "calculationType", alternate = {"CalculationType"})
    @Expose
	@Nullable
    public String calculationType;


    /**
     * Instiaciates a new WorkbookApplicationCalculateParameterSet
     */
    public WorkbookApplicationCalculateParameterSet() {}
    /**
     * Instiaciates a new WorkbookApplicationCalculateParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookApplicationCalculateParameterSet(@Nonnull final WorkbookApplicationCalculateParameterSetBuilder builder) {
        this.calculationType = builder.calculationType;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookApplicationCalculateParameterSetBuilder newBuilder() {
        return new WorkbookApplicationCalculateParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookApplicationCalculateParameterSet
     */
    public static final class WorkbookApplicationCalculateParameterSetBuilder {
        /**
         * The calculationType parameter value
         */
        @Nullable
        protected String calculationType;
        /**
         * Sets the CalculationType
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookApplicationCalculateParameterSetBuilder withCalculationType(@Nullable final String val) {
            this.calculationType = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookApplicationCalculateParameterSetBuilder
         */
        @Nullable
        protected WorkbookApplicationCalculateParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookApplicationCalculateParameterSet build() {
            return new WorkbookApplicationCalculateParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.calculationType != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("calculationType", calculationType));
        }
        return result;
    }
}
