// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.CopyNotebookModel;
import com.microsoft.graph.models.RecentNotebook;
import com.microsoft.graph.requests.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.SectionGroupRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Request.
 */
public class NotebookRequest extends BaseRequest<Notebook> {
	
    /**
     * The request for the Notebook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotebookRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Notebook.class);
    }

    /**
     * Gets the Notebook from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Notebook> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Notebook from the service
     *
     * @return the Notebook from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Notebook get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Notebook> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Notebook delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Notebook with a source
     *
     * @param sourceNotebook the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Notebook> patchAsync(@Nonnull final Notebook sourceNotebook) {
        return sendAsync(HttpMethod.PATCH, sourceNotebook);
    }

    /**
     * Patches this Notebook with a source
     *
     * @param sourceNotebook the source object with updates
     * @return the updated Notebook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Notebook patch(@Nonnull final Notebook sourceNotebook) throws ClientException {
        return send(HttpMethod.PATCH, sourceNotebook);
    }

    /**
     * Creates a Notebook with a new object
     *
     * @param newNotebook the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Notebook> postAsync(@Nonnull final Notebook newNotebook) {
        return sendAsync(HttpMethod.POST, newNotebook);
    }

    /**
     * Creates a Notebook with a new object
     *
     * @param newNotebook the new object to create
     * @return the created Notebook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Notebook post(@Nonnull final Notebook newNotebook) throws ClientException {
        return send(HttpMethod.POST, newNotebook);
    }

    /**
     * Creates a Notebook with a new object
     *
     * @param newNotebook the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Notebook> putAsync(@Nonnull final Notebook newNotebook) {
        return sendAsync(HttpMethod.PUT, newNotebook);
    }

    /**
     * Creates a Notebook with a new object
     *
     * @param newNotebook the object to create/update
     * @return the created Notebook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Notebook put(@Nonnull final Notebook newNotebook) throws ClientException {
        return send(HttpMethod.PUT, newNotebook);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public NotebookRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public NotebookRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

