// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OrganizationalBrandingLocalization;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Localization Request.
 */
public class OrganizationalBrandingLocalizationRequest extends BaseRequest<OrganizationalBrandingLocalization> {
	
    /**
     * The request for the OrganizationalBrandingLocalization
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingLocalizationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBrandingLocalization.class);
    }

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingLocalization> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @return the OrganizationalBrandingLocalization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingLocalization get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingLocalization> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OrganizationalBrandingLocalization delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingLocalization> patchAsync(@Nonnull final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization) {
        return sendAsync(HttpMethod.PATCH, sourceOrganizationalBrandingLocalization);
    }

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @return the updated OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingLocalization patch(@Nonnull final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.PATCH, sourceOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingLocalization> postAsync(@Nonnull final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) {
        return sendAsync(HttpMethod.POST, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingLocalization post(@Nonnull final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.POST, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingLocalization> putAsync(@Nonnull final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) {
        return sendAsync(HttpMethod.PUT, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingLocalization put(@Nonnull final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.PUT, newOrganizationalBrandingLocalization);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OrganizationalBrandingLocalizationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OrganizationalBrandingLocalizationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

