// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ServicePrincipalAddPasswordRequest;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.models.PasswordCredential;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ServicePrincipalAddPasswordParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Add Password Request Builder.
 */
public class ServicePrincipalAddPasswordRequestBuilder extends BaseActionRequestBuilder<PasswordCredential> {

    /**
     * The request builder for this ServicePrincipalAddPassword
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServicePrincipalAddPasswordRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ServicePrincipalAddPasswordParameterSet body;
    /**
     * The request builder for this ServicePrincipalAddPassword
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ServicePrincipalAddPasswordRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ServicePrincipalAddPasswordParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ServicePrincipalAddPasswordRequest
     *
     * @param requestOptions the options for the request
     * @return the ServicePrincipalAddPasswordRequest instance
     */
    @Nonnull
    public ServicePrincipalAddPasswordRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ServicePrincipalAddPasswordRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ServicePrincipalAddPasswordRequest instance
     */
    @Nonnull
    public ServicePrincipalAddPasswordRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ServicePrincipalAddPasswordRequest request = new ServicePrincipalAddPasswordRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
