// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.ItemActivityStat;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.requests.ItemAnalyticsWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.BaseItemCollectionRequestBuilder;
import com.microsoft.graph.requests.BaseItemRequestBuilder;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.ListRequestBuilder;
import com.microsoft.graph.requests.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.PermissionRequestBuilder;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.SiteRequestBuilder;
import com.microsoft.graph.termstore.requests.StoreRequestBuilder;
import com.microsoft.graph.termstore.requests.StoreCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Request.
 */
public class SiteRequest extends BaseRequest<Site> {
	
    /**
     * The request for the Site
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SiteRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    /**
     * Gets the Site from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Site> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Site from the service
     *
     * @return the Site from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Site get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Site> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Site delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Site with a source
     *
     * @param sourceSite the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Site> patchAsync(@Nonnull final Site sourceSite) {
        return sendAsync(HttpMethod.PATCH, sourceSite);
    }

    /**
     * Patches this Site with a source
     *
     * @param sourceSite the source object with updates
     * @return the updated Site
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Site patch(@Nonnull final Site sourceSite) throws ClientException {
        return send(HttpMethod.PATCH, sourceSite);
    }

    /**
     * Creates a Site with a new object
     *
     * @param newSite the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Site> postAsync(@Nonnull final Site newSite) {
        return sendAsync(HttpMethod.POST, newSite);
    }

    /**
     * Creates a Site with a new object
     *
     * @param newSite the new object to create
     * @return the created Site
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Site post(@Nonnull final Site newSite) throws ClientException {
        return send(HttpMethod.POST, newSite);
    }

    /**
     * Creates a Site with a new object
     *
     * @param newSite the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Site> putAsync(@Nonnull final Site newSite) {
        return sendAsync(HttpMethod.PUT, newSite);
    }

    /**
     * Creates a Site with a new object
     *
     * @param newSite the object to create/update
     * @return the created Site
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Site put(@Nonnull final Site newSite) throws ClientException {
        return send(HttpMethod.PUT, newSite);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SiteRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SiteRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

