// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.StopHoldMusicOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Stop Hold Music Operation Request.
 */
public class StopHoldMusicOperationRequest extends BaseRequest<StopHoldMusicOperation> {
	
    /**
     * The request for the StopHoldMusicOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public StopHoldMusicOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, StopHoldMusicOperation.class);
    }

    /**
     * Gets the StopHoldMusicOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<StopHoldMusicOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the StopHoldMusicOperation from the service
     *
     * @return the StopHoldMusicOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public StopHoldMusicOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<StopHoldMusicOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public StopHoldMusicOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this StopHoldMusicOperation with a source
     *
     * @param sourceStopHoldMusicOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<StopHoldMusicOperation> patchAsync(@Nonnull final StopHoldMusicOperation sourceStopHoldMusicOperation) {
        return sendAsync(HttpMethod.PATCH, sourceStopHoldMusicOperation);
    }

    /**
     * Patches this StopHoldMusicOperation with a source
     *
     * @param sourceStopHoldMusicOperation the source object with updates
     * @return the updated StopHoldMusicOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public StopHoldMusicOperation patch(@Nonnull final StopHoldMusicOperation sourceStopHoldMusicOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceStopHoldMusicOperation);
    }

    /**
     * Creates a StopHoldMusicOperation with a new object
     *
     * @param newStopHoldMusicOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<StopHoldMusicOperation> postAsync(@Nonnull final StopHoldMusicOperation newStopHoldMusicOperation) {
        return sendAsync(HttpMethod.POST, newStopHoldMusicOperation);
    }

    /**
     * Creates a StopHoldMusicOperation with a new object
     *
     * @param newStopHoldMusicOperation the new object to create
     * @return the created StopHoldMusicOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public StopHoldMusicOperation post(@Nonnull final StopHoldMusicOperation newStopHoldMusicOperation) throws ClientException {
        return send(HttpMethod.POST, newStopHoldMusicOperation);
    }

    /**
     * Creates a StopHoldMusicOperation with a new object
     *
     * @param newStopHoldMusicOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<StopHoldMusicOperation> putAsync(@Nonnull final StopHoldMusicOperation newStopHoldMusicOperation) {
        return sendAsync(HttpMethod.PUT, newStopHoldMusicOperation);
    }

    /**
     * Creates a StopHoldMusicOperation with a new object
     *
     * @param newStopHoldMusicOperation the object to create/update
     * @return the created StopHoldMusicOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public StopHoldMusicOperation put(@Nonnull final StopHoldMusicOperation newStopHoldMusicOperation) throws ClientException {
        return send(HttpMethod.PUT, newStopHoldMusicOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public StopHoldMusicOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public StopHoldMusicOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

