/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.microsoft.rest.v2.http.HttpHeader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpHeaders
implements Iterable<HttpHeader>,
JsonSerializable {
    private final Map<String, HttpHeader> headers = new HashMap<String, HttpHeader>();

    public HttpHeaders() {
    }

    public HttpHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.set(header.getKey(), header.getValue());
        }
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        this();
        for (HttpHeader header : headers) {
            this.set(header.name(), header.value());
        }
    }

    public int size() {
        return this.headers.size();
    }

    public HttpHeaders set(String headerName, String headerValue) {
        String headerKey = headerName.toLowerCase();
        if (headerValue == null) {
            this.headers.remove(headerKey);
        } else {
            this.headers.put(headerKey, new HttpHeader(headerName, headerValue));
        }
        return this;
    }

    public String value(String headerName) {
        HttpHeader header = this.getHeader(headerName);
        return header == null ? null : header.value();
    }

    public String[] values(String headerName) {
        HttpHeader header = this.getHeader(headerName);
        return header == null ? null : header.values();
    }

    private HttpHeader getHeader(String headerName) {
        String headerKey = headerName.toLowerCase();
        return this.headers.get(headerKey);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpHeader header : this.headers.values()) {
            result.put(header.name(), header.value());
        }
        return result;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(this.toMap());
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }
}

