/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpPipelineBuilder;
import com.microsoft.rest.v2.http.HttpPipelineLogger;
import com.microsoft.rest.v2.http.HttpPipelineOptions;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.HttpClientRequestPolicyAdapter;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.Arrays;

public final class HttpPipeline {
    private final RequestPolicyFactory[] requestPolicyFactories;
    private final HttpClientRequestPolicyAdapter httpClientRequestPolicyAdapter;
    private final RequestPolicyOptions requestPolicyOptions;

    HttpPipeline(RequestPolicyFactory[] requestPolicyFactories, HttpPipelineOptions options) {
        this.requestPolicyFactories = requestPolicyFactories;
        HttpClient httpClient = options != null && options.httpClient() != null ? options.httpClient() : HttpClient.createDefault();
        this.httpClientRequestPolicyAdapter = new HttpClientRequestPolicyAdapter(httpClient);
        HttpPipelineLogger logger = options != null ? options.logger() : null;
        this.requestPolicyOptions = new RequestPolicyOptions(logger);
    }

    public Single<HttpResponse> sendRequestAsync(HttpRequest httpRequest) {
        RequestPolicy requestPolicy = this.httpClientRequestPolicyAdapter;
        for (RequestPolicyFactory requestPolicyFactory : this.requestPolicyFactories) {
            requestPolicy = requestPolicyFactory.create(requestPolicy, this.requestPolicyOptions);
        }
        return requestPolicy.sendAsync(httpRequest);
    }

    public static HttpPipeline build(Iterable<RequestPolicyFactory> requestPolicyFactories) {
        return HttpPipeline.build(null, requestPolicyFactories);
    }

    public static HttpPipeline build(RequestPolicyFactory ... requestPolicyFactories) {
        return HttpPipeline.build((HttpPipelineOptions)null, requestPolicyFactories);
    }

    public static HttpPipeline build(HttpClient httpClient, RequestPolicyFactory ... requestPolicyFactories) {
        return HttpPipeline.build(new HttpPipelineOptions().withHttpClient(httpClient), requestPolicyFactories);
    }

    public static HttpPipeline build(HttpPipelineOptions pipelineOptions, RequestPolicyFactory ... requestPolicyFactories) {
        return HttpPipeline.build(pipelineOptions, Arrays.asList(requestPolicyFactories));
    }

    public static HttpPipeline build(HttpPipelineOptions pipelineOptions, Iterable<RequestPolicyFactory> requestPolicyFactories) {
        HttpPipelineBuilder builder = new HttpPipelineBuilder(pipelineOptions);
        if (requestPolicyFactories != null) {
            for (RequestPolicyFactory requestPolicyFactory : requestPolicyFactories) {
                builder.withRequestPolicy(requestPolicyFactory);
            }
        }
        return builder.build();
    }
}

