/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.ConcurrentMultiDequeMap;
import com.microsoft.rest.v2.http.SharedChannelPoolOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedChannelPool
implements ChannelPool {
    private static final AttributeKey<URI> CHANNEL_URI = AttributeKey.newInstance((String)"channel-uri");
    private static final AttributeKey<ZonedDateTime> CHANNEL_AVAILABLE_SINCE = AttributeKey.newInstance((String)"channel-available-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_LEASED_SINCE = AttributeKey.newInstance((String)"channel-leased-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_CREATED_SINCE = AttributeKey.newInstance((String)"channel-created-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_CLOSED_SINCE = AttributeKey.newInstance((String)"channel-closed-since");
    private final Bootstrap bootstrap;
    private final EventLoopGroup eventLoopGroup;
    private final ChannelPoolHandler handler;
    private final int poolSize;
    private final AtomicInteger channelCount = new AtomicInteger(0);
    private final SharedChannelPoolOptions poolOptions;
    private final ConcurrentMultiDequeMap<URI, ChannelRequest> requests;
    private final ConcurrentMultiDequeMap<URI, Channel> available;
    private final ConcurrentMultiDequeMap<URI, Channel> leased;
    private final Object sync = new Object();
    private final SslContext sslContext;
    private volatile boolean closed = false;
    private final Logger logger = LoggerFactory.getLogger(SharedChannelPool.class);
    AtomicInteger wip = new AtomicInteger(0);

    private boolean isChannelHealthy(Channel channel) {
        try {
            long channelIdleDurationInSec;
            if (!channel.isActive()) {
                return false;
            }
            if (channel.pipeline().get("HttpResponseDecoder") == null && channel.pipeline().get("HttpClientCodec") == null) {
                return false;
            }
            ZonedDateTime channelAvailableSince = (ZonedDateTime)channel.attr(CHANNEL_AVAILABLE_SINCE).get();
            if (channelAvailableSince == null) {
                channelAvailableSince = (ZonedDateTime)channel.attr(CHANNEL_LEASED_SINCE).get();
            }
            return (channelIdleDurationInSec = ChronoUnit.SECONDS.between(channelAvailableSince, ZonedDateTime.now(ZoneOffset.UTC))) < this.poolOptions.idleChannelKeepAliveDurationInSec();
        }
        catch (Throwable t) {
            return false;
        }
    }

    SharedChannelPool(Bootstrap bootstrap, EventLoopGroup eventLoopGroup, ChannelPoolHandler handler, SharedChannelPoolOptions options, SslContext sslContext) {
        this.poolOptions = options.clone();
        this.bootstrap = bootstrap.clone();
        this.eventLoopGroup = eventLoopGroup;
        this.handler = handler;
        this.poolSize = options.poolSize();
        this.requests = new ConcurrentMultiDequeMap();
        this.available = new ConcurrentMultiDequeMap();
        this.leased = new ConcurrentMultiDequeMap();
        try {
            this.sslContext = sslContext == null ? SslContextBuilder.forClient().build() : sslContext;
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private void drain(URI preferredUri) {
        if (!this.wip.compareAndSet(0, 1)) {
            return;
        }
        while (!this.closed && this.wip.updateAndGet(x -> this.requests.size()) != 0) {
            if (this.channelCount.get() >= this.poolSize && this.available.size() == 0) {
                this.wip.set(0);
                break;
            }
            final ChannelRequest request = preferredUri != null && this.requests.containsKey(preferredUri) ? this.requests.poll(preferredUri) : this.requests.poll();
            boolean foundHealthyChannelInPool = false;
            if (this.available.containsKey(request.channelURI)) {
                Channel channel = this.available.pop(request.channelURI);
                if (this.isChannelHealthy(channel)) {
                    this.logger.debug("Channel picked up from pool: {}", (Object)channel.id());
                    this.leased.put(request.channelURI, channel);
                    foundHealthyChannelInPool = true;
                    channel.attr(CHANNEL_LEASED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                    request.promise.setSuccess((Object)channel);
                    try {
                        this.handler.channelAcquired(channel);
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                } else {
                    this.logger.debug("Channel disposed from pool due to timeout or half closure: {}", (Object)channel.id());
                    this.closeChannel(channel);
                    this.channelCount.decrementAndGet();
                    while (this.available.containsKey(request.channelURI)) {
                        Channel broken = this.available.pop(request.channelURI);
                        this.logger.debug("Channel disposed from pool due to timeout or half closure: {}", (Object)broken.id());
                        this.closeChannel(broken);
                        this.channelCount.decrementAndGet();
                    }
                }
            }
            if (foundHealthyChannelInPool) continue;
            if (this.channelCount.get() >= this.poolSize) {
                Channel nextAvailable = this.available.poll();
                this.logger.debug("Channel disposed due to overflow: {}", (Object)nextAvailable.id());
                this.closeChannel(nextAvailable);
                this.channelCount.decrementAndGet();
            }
            int port = request.destinationURI.getPort() < 0 ? ("https".equals(request.destinationURI.getScheme()) ? 443 : 80) : request.destinationURI.getPort();
            this.channelCount.incrementAndGet();
            ((Bootstrap)this.bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    assert (ch.eventLoop().inEventLoop());
                    if (request.proxy != null) {
                        ch.pipeline().addFirst("HttpProxyHandler", (ChannelHandler)new HttpProxyHandler(request.proxy.address()));
                    }
                    SharedChannelPool.this.handler.channelCreated(ch);
                }
            })).connect(request.destinationURI.getHost(), port).addListener(f -> {
                if (f.isSuccess()) {
                    Channel channel = f.channel();
                    channel.attr(CHANNEL_URI).set((Object)request.channelURI);
                    if ("https".equalsIgnoreCase(request.destinationURI.getScheme())) {
                        channel.pipeline().addBefore("HttpClientCodec", "SslHandler", (ChannelHandler)this.sslContext.newHandler(channel.alloc(), request.destinationURI.getHost(), port));
                    }
                    this.leased.put(request.channelURI, channel);
                    channel.attr(CHANNEL_CREATED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                    channel.attr(CHANNEL_LEASED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                    this.logger.debug("Channel created: {}", (Object)channel.id());
                    this.handler.channelAcquired(channel);
                    request.promise.setSuccess((Object)channel);
                } else {
                    request.promise.setFailure(f.cause());
                    this.channelCount.decrementAndGet();
                }
            });
        }
    }

    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy) {
        return this.acquire(uri, proxy, (Promise<Channel>)this.bootstrap.config().group().next().newPromise());
    }

    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy, Promise<Channel> promise) {
        if (this.closed) {
            throw new RejectedExecutionException("SharedChannelPool is closed");
        }
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.promise = promise;
        channelRequest.proxy = proxy;
        int port = uri.getPort() < 0 ? ("https".equals(uri.getScheme()) ? 443 : 80) : uri.getPort();
        try {
            channelRequest.destinationURI = new URI(String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), port));
            if (proxy == null) {
                channelRequest.channelURI = channelRequest.destinationURI;
            } else {
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                channelRequest.channelURI = new URI(String.format("%s://%s:%d", uri.getScheme(), address.getHostString(), address.getPort()));
            }
            this.requests.put(channelRequest.channelURI, channelRequest);
            this.drain(null);
        }
        catch (URISyntaxException e) {
            promise.setFailure((Throwable)e);
        }
        return channelRequest.promise;
    }

    public Future<Channel> acquire() {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    private Future<Void> closeChannel(Channel channel) {
        if (!channel.isOpen()) {
            return new SucceededFuture((EventExecutor)this.eventLoopGroup.next(), null);
        }
        channel.attr(CHANNEL_CLOSED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
        this.logger.debug("Channel initiated to close: " + channel.id());
        try {
            return channel.close().addListener(f -> {
                if (!f.isSuccess()) {
                    this.logger.warn("Possible channel leak: failed to close " + channel.id(), f.cause());
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Possible channel leak: failed to close " + channel.id(), (Throwable)e);
            return new FailedFuture((EventExecutor)this.eventLoopGroup.next(), (Throwable)e);
        }
    }

    public Future<Void> closeAndRelease(Channel channel) {
        try {
            Future closeFuture = this.closeChannel(channel).addListener(future -> {
                URI channelUri = (URI)channel.attr(CHANNEL_URI).get();
                if (this.leased.remove(channelUri, channel) || this.available.remove(channelUri, channel)) {
                    this.channelCount.decrementAndGet();
                    this.logger.debug("Channel closed and released out of pool: " + channel.id());
                }
                this.drain(channelUri);
            });
            return closeFuture;
        }
        catch (Exception e) {
            return this.bootstrap.config().group().next().newFailedFuture((Throwable)e);
        }
    }

    public Future<Void> release(Channel channel) {
        try {
            this.handler.channelReleased(channel);
            URI channelUri = (URI)channel.attr(CHANNEL_URI).get();
            this.leased.remove(channelUri, channel);
            if (this.isChannelHealthy(channel)) {
                this.available.put(channelUri, channel);
                channel.attr(CHANNEL_AVAILABLE_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                this.logger.debug("Channel released to pool: " + channel.id());
            } else {
                this.channelCount.decrementAndGet();
                this.logger.debug("Channel broken on release, dispose: " + channel.id());
            }
            this.drain(channelUri);
        }
        catch (Exception e) {
            return this.bootstrap.config().group().next().newFailedFuture((Throwable)e);
        }
        return this.bootstrap.config().group().next().newSucceededFuture(null);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.release(channel).addListener(f -> {
            if (f.isSuccess()) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(f.cause());
            }
        });
    }

    public void close() {
        this.closed = true;
        while (this.requests.size() != 0) {
            this.requests.poll().promise.setFailure((Throwable)new CancellationException("Channel pool was closed"));
        }
    }

    public void dump() {
        long age;
        long stateFor;
        this.logger.info(String.format("---- %s: size %d, keep alive (sec) %d ----", this.toString(), this.poolSize, this.poolOptions.idleChannelKeepAliveDurationInSec()));
        this.logger.info("Channel\tState\tFor\tAge\tURL");
        ArrayList<Channel> closed = new ArrayList<Channel>();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        for (Channel channel : this.leased.values()) {
            if (channel.hasAttr(CHANNEL_CLOSED_SINCE)) {
                closed.add(channel);
                continue;
            }
            stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_LEASED_SINCE).get(), now);
            age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
            this.logger.info(String.format("%s\tLEASE\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
        }
        for (Channel channel : this.available.values()) {
            if (channel.hasAttr(CHANNEL_CLOSED_SINCE)) {
                closed.add(channel);
                continue;
            }
            stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_AVAILABLE_SINCE).get(), now);
            age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
            this.logger.info(String.format("%s\tAVAIL\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
        }
        for (Channel channel : closed) {
            stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CLOSED_SINCE).get(), now);
            age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
            this.logger.info(String.format("%s\tCLOSE\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
        }
        this.logger.info("Active channels: " + this.channelCount.get() + " Leaked or being initialized channels: " + (this.channelCount.get() - this.leased.size() - this.available.size()));
    }

    private static class ChannelRequest {
        private URI destinationURI;
        private URI channelURI;
        private Proxy proxy;
        private Promise<Channel> promise;

        private ChannelRequest() {
        }
    }
}

